/*
 * Decompiled with CFR 0.152.
 */
package nxt.dgs;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.blockchain.Appendix;
import nxt.crypto.EncryptedData;
import nxt.dgs.DeliveryAttachment;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class UnencryptedDeliveryAttachment
extends DeliveryAttachment
implements Appendix.Encryptable {
    private final byte[] goodsToEncrypt;
    private final byte[] recipientPublicKey;

    UnencryptedDeliveryAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.setGoods(null);
        String string = (String)jSONObject.get((Object)"goodsToEncrypt");
        this.goodsToEncrypt = this.goodsIsText() ? Convert.toBytes(string) : Convert.parseHexString(string);
        this.recipientPublicKey = Convert.parseHexString((String)jSONObject.get((Object)"recipientPublicKey"));
    }

    public UnencryptedDeliveryAttachment(long l, byte[] byArray, boolean bl, long l2, byte[] byArray2) {
        super(l, null, bl, l2);
        this.goodsToEncrypt = byArray;
        this.recipientPublicKey = byArray2;
    }

    @Override
    protected int getMySize() {
        if (this.getGoods() == null) {
            return 12 + EncryptedData.getEncryptedSize(this.getPlaintext()) + 8;
        }
        return super.getMySize();
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        if (this.getGoods() == null) {
            throw new NxtException.NotYetEncryptedException("Goods not yet encrypted");
        }
        super.putMyBytes(byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        if (this.getGoods() == null) {
            jSONObject.put((Object)"goodsToEncrypt", (Object)(this.goodsIsText() ? Convert.toString(this.goodsToEncrypt) : Convert.toHexString(this.goodsToEncrypt)));
            jSONObject.put((Object)"recipientPublicKey", (Object)Convert.toHexString(this.recipientPublicKey));
            jSONObject.put((Object)"purchase", (Object)Long.toUnsignedString(this.getPurchaseId()));
            jSONObject.put((Object)"discountNQT", (Object)this.getDiscountNQT());
            jSONObject.put((Object)"goodsIsText", (Object)this.goodsIsText());
        } else {
            super.putMyJSON(jSONObject);
        }
    }

    @Override
    public void encrypt(String string) {
        this.setGoods(EncryptedData.encrypt(this.getPlaintext(), string, this.recipientPublicKey));
    }

    @Override
    int getGoodsDataLength() {
        return EncryptedData.getEncryptedDataLength(this.getPlaintext());
    }

    private byte[] getPlaintext() {
        return Convert.compress(this.goodsToEncrypt);
    }
}

