/*
 * Decompiled with CFR 0.152.
 */
package nxt.env;

import java.io.File;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import nxt.env.DesktopSystemTray;
import nxt.env.LookAndFeel;
import nxt.env.RuntimeMode;
import nxt.env.ServerStatus;
import nxt.env.SystemTrayDataProvider;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;

public class DesktopMode
implements RuntimeMode {
    private DesktopSystemTray desktopSystemTray;
    private Class desktopApplication;

    @Override
    public void init() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("desktop"));
        }
        LookAndFeel.init();
        this.desktopSystemTray = new DesktopSystemTray();
        SwingUtilities.invokeLater(this.desktopSystemTray::createAndShowGUI);
    }

    @Override
    public void setServerStatus(ServerStatus serverStatus, URI uRI, File file) {
        if (this.desktopSystemTray != null) {
            this.desktopSystemTray.setToolTip(new SystemTrayDataProvider(serverStatus.getMessage(), uRI, file));
        }
    }

    @Override
    public void launchDesktopApplication() {
        Logger.logInfoMessage("Launching desktop wallet in a new thread");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            try {
                this.desktopApplication = Class.forName("nxtdesktop.DesktopApplication");
                this.desktopApplication.getMethod("launch", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Logger.logInfoMessage("nxtdesktop.DesktopApplication failed to launch", reflectiveOperationException);
            }
            Logger.logInfoMessage("Desktop wallet shutdown completed");
        });
    }

    @Override
    public void shutdown() {
        if (this.desktopSystemTray != null) {
            this.desktopSystemTray.shutdown();
        }
        if (this.desktopApplication == null) {
            return;
        }
        try {
            this.desktopApplication.getMethod("shutdown", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Logger.logInfoMessage("nxtdesktop.DesktopApplication failed to shutdown", reflectiveOperationException);
        }
    }

    @Override
    public void alert(String string) {
        this.desktopSystemTray.alert(string);
    }
}

