/*
 * Decompiled with CFR 0.152.
 */
package nxt.env;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import nxt.Constants;
import nxt.Nxt;
import nxt.blockchain.Block;
import nxt.blockchain.Generator;
import nxt.dbschema.Db;
import nxt.env.RuntimeEnvironment;
import nxt.env.SystemTrayDataProvider;
import nxt.http.API;
import nxt.peer.NetworkHandler;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.Logger;

class DesktopSystemTray {
    private static final int DELAY = 1000;
    private SystemTray tray;
    private final JFrame wrapper = new JFrame();
    private JDialog statusDialog;
    private JPanel statusPanel;
    private ImageIcon imageIcon;
    private TrayIcon trayIcon;
    private MenuItem openWalletInBrowser;
    private MenuItem viewLog;
    private SystemTrayDataProvider dataProvider;
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2, Locale.getDefault());
    private float dpi;

    DesktopSystemTray() {
    }

    void createAndShowGUI() {
        if (!SystemTray.isSupported()) {
            Logger.logInfoMessage("SystemTray is not supported");
            return;
        }
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        this.dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        Logger.logDebugMessage("Display DPI = " + this.dpi);
        PopupMenu popupMenu = new PopupMenu();
        this.imageIcon = new ImageIcon("html/www/img/nxt-icon-32x32.png", "tray icon");
        this.trayIcon = new TrayIcon(this.imageIcon.getImage());
        this.trayIcon.setImageAutoSize(true);
        this.tray = SystemTray.getSystemTray();
        MenuItem menuItem = this.getMenuItem("Shutdown");
        this.openWalletInBrowser = this.getMenuItem("Open Wallet in Browser");
        if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            this.openWalletInBrowser.setEnabled(false);
        }
        MenuItem menuItem2 = this.getMenuItem("Show Desktop Application");
        MenuItem menuItem3 = this.getMenuItem("Refresh Wallet");
        if (!RuntimeEnvironment.isDesktopApplicationEnabled()) {
            menuItem2.setEnabled(false);
            menuItem3.setEnabled(false);
        }
        this.viewLog = this.getMenuItem("View Log File");
        if (!Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            this.viewLog.setEnabled(false);
        }
        MenuItem menuItem4 = this.getMenuItem("Status");
        popupMenu.add(menuItem4);
        popupMenu.add(this.viewLog);
        popupMenu.addSeparator();
        popupMenu.add(this.openWalletInBrowser);
        popupMenu.add(menuItem2);
        popupMenu.add(menuItem3);
        popupMenu.addSeparator();
        popupMenu.add(menuItem);
        this.trayIcon.setPopupMenu(popupMenu);
        this.trayIcon.setToolTip("Initializing");
        try {
            this.tray.add(this.trayIcon);
        }
        catch (AWTException aWTException) {
            Logger.logInfoMessage("TrayIcon could not be added", aWTException);
            return;
        }
        this.trayIcon.addActionListener(actionEvent -> this.displayStatus());
        this.openWalletInBrowser.addActionListener(actionEvent -> {
            try {
                Desktop.getDesktop().browse(this.dataProvider.getWallet());
            }
            catch (IOException iOException) {
                Logger.logInfoMessage("Cannot open wallet in browser", iOException);
            }
        });
        menuItem2.addActionListener(actionEvent -> {
            try {
                Class.forName("nxtdesktop.DesktopApplication").getMethod("launch", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Logger.logInfoMessage("nxtdesktop.DesktopApplication failed to launch", reflectiveOperationException);
            }
        });
        menuItem3.addActionListener(actionEvent -> {
            try {
                Class.forName("nxtdesktop.DesktopApplication").getMethod("refresh", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                Logger.logInfoMessage("nxtdesktop.DesktopApplication failed to refresh", reflectiveOperationException);
            }
        });
        this.viewLog.addActionListener(actionEvent -> {
            try {
                Desktop.getDesktop().open(this.dataProvider.getLogFile());
            }
            catch (IOException iOException) {
                Logger.logInfoMessage("Cannot view log", iOException);
            }
        });
        menuItem4.addActionListener(actionEvent -> this.displayStatus());
        menuItem.addActionListener(actionEvent -> {
            if (JOptionPane.showConfirmDialog(null, "Sure you want to shutdown Ardor?\n\nIf you do, this will stop forging, bundling, shufflers and account monitors.\n\n", "Shutdown", 0) == 0) {
                Logger.logInfoMessage("Shutdown requested by System Tray");
                System.exit(0);
            }
        });
        ActionListener actionListener = actionEvent -> {
            if (this.statusDialog == null || !this.statusDialog.isVisible()) {
                return;
            }
            this.displayStatus();
        };
        new Timer(1000, actionListener).start();
    }

    private void displayStatus() {
        Block block = Nxt.getBlockchain().getLastBlock();
        Collection<Generator> collection = Generator.getAllGenerators();
        StringBuilder stringBuilder = new StringBuilder();
        for (Generator object2 : collection) {
            stringBuilder.append(Convert.rsAccount(object2.getAccountId())).append(' ');
        }
        Object object3 = UIManager.get("OptionPane.background");
        UIManager.put("OptionPane.background", Color.WHITE);
        Object object = UIManager.get("Panel.background");
        UIManager.put("Panel.background", Color.WHITE);
        Object object2 = UIManager.get("TextField.background");
        UIManager.put("TextField.background", Color.WHITE);
        Container container = null;
        if (this.statusDialog != null && this.statusPanel != null) {
            container = this.statusPanel.getParent();
            container.remove(this.statusPanel);
        }
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 1));
        this.addLabelRow(this.statusPanel, "Installation");
        this.addDataRow(this.statusPanel, "Application", "Ardor");
        this.addDataRow(this.statusPanel, "Version", "2.2.6");
        this.addDataRow(this.statusPanel, "Network", Constants.isTestnet ? "TestNet" : "MainNet");
        this.addDataRow(this.statusPanel, "Working offline", "" + Constants.isOffline);
        this.addDataRow(this.statusPanel, "Wallet", String.valueOf(API.getWelcomePageUri()));
        this.addDataRow(this.statusPanel, "Peer port", String.valueOf(NetworkHandler.getDefaultPeerPort()));
        this.addDataRow(this.statusPanel, "Program folder", String.valueOf(Paths.get(".", new String[0]).toAbsolutePath().getParent()));
        this.addDataRow(this.statusPanel, "User folder", String.valueOf(Paths.get(Nxt.getUserHomeDir(), new String[0]).toAbsolutePath()));
        this.addDataRow(this.statusPanel, "Database URL", Db.db.getUrl());
        this.addEmptyRow(this.statusPanel);
        if (block != null) {
            this.addLabelRow(this.statusPanel, "Last Block");
            this.addDataRow(this.statusPanel, "Height", String.valueOf(block.getHeight()));
            this.addDataRow(this.statusPanel, "Timestamp", String.valueOf(block.getTimestamp()));
            this.addDataRow(this.statusPanel, "Time", String.valueOf(new Date(Convert.fromEpochTime(block.getTimestamp()))));
            this.addDataRow(this.statusPanel, "Seconds passed", String.valueOf(Nxt.getEpochTime() - block.getTimestamp()));
            this.addDataRow(this.statusPanel, "Forging", String.valueOf(collection.size() > 0));
            if (collection.size() > 0) {
                this.addDataRow(this.statusPanel, "Forging accounts", stringBuilder.toString());
            }
        }
        this.addEmptyRow(this.statusPanel);
        this.addLabelRow(this.statusPanel, "Environment");
        this.addDataRow(this.statusPanel, "Number of peers", String.valueOf(Peers.getAllPeers().size()));
        this.addDataRow(this.statusPanel, "Available processors", String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.addDataRow(this.statusPanel, "Max memory", DesktopSystemTray.humanReadableByteCount(Runtime.getRuntime().maxMemory()));
        this.addDataRow(this.statusPanel, "Total memory", DesktopSystemTray.humanReadableByteCount(Runtime.getRuntime().totalMemory()));
        this.addDataRow(this.statusPanel, "Free memory", DesktopSystemTray.humanReadableByteCount(Runtime.getRuntime().freeMemory()));
        this.addDataRow(this.statusPanel, "Process id", Nxt.getProcessId());
        this.addEmptyRow(this.statusPanel);
        this.addDataRow(this.statusPanel, "Updated", this.dateFormat.format(new Date()));
        if (this.statusDialog == null || !this.statusDialog.isVisible()) {
            JOptionPane jOptionPane = new JOptionPane(this.statusPanel, -1, -1, this.imageIcon);
            this.statusDialog = jOptionPane.createDialog(this.wrapper, "Ardor Server Status");
            this.statusDialog.setVisible(true);
            this.statusDialog.dispose();
        } else {
            if (container != null) {
                container.add(this.statusPanel);
                container.revalidate();
            }
            this.statusDialog.getContentPane().validate();
            this.statusDialog.getContentPane().repaint();
            EventQueue.invokeLater(this.statusDialog::toFront);
        }
        UIManager.put("OptionPane.background", object3);
        UIManager.put("Panel.background", object);
        UIManager.put("TextField.background", object2);
    }

    private void addDataRow(JPanel jPanel, String string, String string2) {
        JPanel jPanel2 = new JPanel();
        if (!"".equals(string2)) {
            jPanel2.add(Box.createRigidArea(new Dimension(20, 0)));
        }
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        if (!"".equals(string) && !"".equals(string2)) {
            string = string + ':';
        }
        JLabel jLabel = new JLabel(string);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(140 - jLabel.getPreferredSize().width, 0)));
        JTextField jTextField = new JTextField(string2);
        jTextField.setEditable(false);
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        jPanel2.add(jTextField);
        jPanel2.add(Box.createRigidArea(new Dimension(4, 0)));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(0, 4)));
    }

    private void addLabelRow(JPanel jPanel, String string) {
        this.addDataRow(jPanel, string, "");
    }

    private void addEmptyRow(JPanel jPanel) {
        this.addLabelRow(jPanel, "");
    }

    void setToolTip(SystemTrayDataProvider systemTrayDataProvider) {
        SwingUtilities.invokeLater(() -> {
            this.trayIcon.setToolTip(systemTrayDataProvider.getToolTip());
            this.openWalletInBrowser.setEnabled(systemTrayDataProvider.getWallet() != null && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE));
            this.viewLog.setEnabled(systemTrayDataProvider.getWallet() != null);
            this.dataProvider = systemTrayDataProvider;
        });
    }

    void shutdown() {
        SwingUtilities.invokeLater(() -> this.tray.remove(this.trayIcon));
    }

    private static String humanReadableByteCount(long l) {
        int n = 1000;
        if (l < (long)n) {
            return l + " B";
        }
        int n2 = (int)(Math.log(l) / Math.log(n));
        String string = "" + "KMGTPE".charAt(n2 - 1);
        return String.format("%.1f %sB", (double)l / Math.pow(n, n2), string);
    }

    void alert(String string) {
        JOptionPane.showMessageDialog(null, string, "Initialization Error", 0);
    }

    private MenuItem getMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        if (this.dpi > 120.0f) {
            Font font = new Font("sans-serif", 0, (int)this.dpi / 10);
            menuItem.setFont(font);
        }
        return menuItem;
    }
}

