/*
 * Decompiled with CFR 0.152.
 */
package nxt.freeze;

import nxt.account.HoldingType;
import nxt.blockchain.Block;
import nxt.db.DbIterator;
import nxt.db.TransactionalDb;
import nxt.freeze.HoldingFreeze;
import nxt.util.Listener;

public abstract class AbstractFreezeBlockHandler
implements Listener<Block> {
    private final HoldingType holdingType;

    protected AbstractFreezeBlockHandler(HoldingType holdingType) {
        this.holdingType = holdingType;
    }

    @Override
    public final void notify(Block block) {
        int n = block.getHeight();
        try (DbIterator<HoldingFreeze> dbIterator = HoldingFreeze.getFreezes(this.holdingType, n);){
            for (HoldingFreeze holdingFreeze : dbIterator) {
                TransactionalDb.runInDbTransaction(() -> this.handleFreeze(holdingFreeze.getHoldingId()));
            }
        }
    }

    protected abstract void handleFreeze(long var1);
}

