/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import nxt.Constants;
import nxt.Nxt;
import nxt.configuration.SubSystem;
import nxt.http.API;
import nxt.http.APIEnum;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import nxt.util.security.BlockchainPermission;

public class APIProxy {
    static final Set<String> NOT_FORWARDED_REQUESTS;
    private static final APIProxy instance;
    static final boolean enableAPIProxy;
    private static final int blacklistingPeriod;
    static final String forcedServerURL;
    private volatile String forcedPeerHost;
    private volatile List<String> peersHosts = Collections.emptyList();
    private volatile String mainPeerAnnouncedAddress;
    private final Map<String, Integer> blacklistedPeers = new ConcurrentHashMap<String, Integer>();
    private static final Runnable peersUpdateThread;

    private APIProxy() {
    }

    public static void init() {
    }

    public static APIProxy getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("api"));
        }
        return instance;
    }

    Peer getServingPeer(String string) {
        Object object;
        Object object2;
        Object object3;
        if (this.forcedPeerHost != null) {
            return Peers.getPeer(this.forcedPeerHost);
        }
        APIEnum aPIEnum = APIEnum.fromName(string);
        if (!this.peersHosts.isEmpty()) {
            object3 = this.peersHosts.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = Peers.getPeer((String)object2);
                if (object == null || !object.isApiConnectable() || object.getDisabledAPIs().contains((Object)aPIEnum)) continue;
                return object;
            }
        }
        if ((object3 = Peers.getPeers(peer -> peer.isApiConnectable() && !this.blacklistedPeers.containsKey(peer.getHost()))).isEmpty()) {
            return null;
        }
        object2 = this.getRandomAPIPeer((List<Peer>)object3);
        if (object2 == null) {
            return null;
        }
        object = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        EnumSet<APIEnum> enumSet = EnumSet.noneOf(APIEnum.class);
        arrayList.add(object2.getHost());
        this.mainPeerAnnouncedAddress = object2.getAnnouncedAddress();
        if (!object2.getDisabledAPIs().contains((Object)aPIEnum)) {
            object = object2;
        }
        while (!enumSet.isEmpty() && !object3.isEmpty()) {
            object3.removeIf(peer -> peer.getDisabledAPIs().containsAll(enumSet));
            object2 = this.getRandomAPIPeer((List<Peer>)object3);
            if (object2 == null) continue;
            arrayList.add(object2.getHost());
            if (!object2.getDisabledAPIs().contains((Object)aPIEnum)) {
                object = object2;
            }
            enumSet.retainAll(object2.getDisabledAPIs());
        }
        this.peersHosts = Collections.unmodifiableList(arrayList);
        Logger.logInfoMessage("Selected API peer " + object + " peer hosts selected " + arrayList);
        return object;
    }

    Peer setForcedPeer(Peer peer) {
        if (peer != null) {
            this.forcedPeerHost = peer.getHost();
            this.mainPeerAnnouncedAddress = peer.getAnnouncedAddress();
            return peer;
        }
        this.forcedPeerHost = null;
        this.mainPeerAnnouncedAddress = null;
        return this.getServingPeer(null);
    }

    String getMainPeerAnnouncedAddress() {
        Peer peer;
        if (this.mainPeerAnnouncedAddress == null && (peer = this.getServingPeer(null)) != null) {
            this.mainPeerAnnouncedAddress = peer.getAnnouncedAddress();
        }
        return this.mainPeerAnnouncedAddress;
    }

    static boolean isActivated() {
        return Constants.isLightClient || enableAPIProxy && Nxt.getBlockchainProcessor().isDownloading();
    }

    boolean blacklistHost(String string) {
        if (this.blacklistedPeers.size() > 1000) {
            Logger.logInfoMessage("Too many blacklisted peers");
            return false;
        }
        this.blacklistedPeers.put(string, Nxt.getEpochTime() + blacklistingPeriod);
        if (this.peersHosts.contains(string)) {
            this.peersHosts = Collections.emptyList();
            this.getServingPeer(null);
        }
        return true;
    }

    private Peer getRandomAPIPeer(List<Peer> list) {
        if (list.isEmpty()) {
            return null;
        }
        int n = ThreadLocalRandom.current().nextInt(list.size());
        return list.remove(n);
    }

    static {
        instance = new APIProxy();
        enableAPIProxy = Constants.isLightClient || Nxt.getBooleanProperty("nxt.enableAPIProxy") && !API.isOpenAPI && Nxt.isEnabled(SubSystem.PEER_NETWORKING);
        blacklistingPeriod = Nxt.getIntProperty("nxt.apiProxyBlacklistingPeriod") / 1000;
        forcedServerURL = Nxt.getStringProperty("nxt.forceAPIProxyServerURL", "");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("getBlockchainStatus");
        hashSet.add("getState");
        EnumSet<APITag> enumSet = EnumSet.of(APITag.DEBUG, APITag.NETWORK);
        for (APIEnum aPIEnum : APIEnum.values()) {
            APIServlet.APIRequestHandler aPIRequestHandler = aPIEnum.getHandler();
            if (!aPIRequestHandler.requireBlockchain() || Collections.disjoint(aPIRequestHandler.getAPITags(), enumSet)) continue;
            hashSet.add(aPIEnum.getName());
        }
        NOT_FORWARDED_REQUESTS = Collections.unmodifiableSet(hashSet);
        peersUpdateThread = () -> {
            int n = Nxt.getEpochTime();
            APIProxy.instance.blacklistedPeers.entrySet().removeIf(entry -> {
                if ((Integer)entry.getValue() < n) {
                    Logger.logDebugMessage("Unblacklisting API peer " + (String)entry.getKey());
                    return true;
                }
                return false;
            });
            List<String> list = APIProxy.instance.peersHosts;
            if (list != null && Peers.isNetworkingEnabled()) {
                for (String string : list) {
                    Peer peer = Peers.getPeer(string);
                    if (peer == null) continue;
                    peer.connectPeer();
                }
            }
        };
        if (!Constants.isOffline && enableAPIProxy) {
            ThreadPool.scheduleThread("APIProxyPeersUpdate", peersUpdateThread, 60);
        }
    }
}

