/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.http.APIProxy;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class BlacklistAPIProxyPeer
extends APIServlet.APIRequestHandler {
    static final BlacklistAPIProxyPeer instance = new BlacklistAPIProxyPeer();

    private BlacklistAPIProxyPeer() {
        super(new APITag[]{APITag.NETWORK}, "peer");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("peer"));
        if (string == null) {
            return JSONResponses.MISSING_PEER;
        }
        Peer peer = Peers.findOrCreatePeer(string, true);
        JSONObject jSONObject = new JSONObject();
        if (peer == null) {
            return JSONResponses.UNKNOWN_PEER;
        }
        jSONObject.put((Object)"done", (Object)APIProxy.getInstance().blacklistHost(peer.getHost()));
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean requirePassword() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

