/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import nxt.Constants;
import nxt.NxtException;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.peer.Peers;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class CalculateFee
extends APIServlet.APIRequestHandler {
    static final CalculateFee instance = new CalculateFee();

    private CalculateFee() {
        super(new APITag[]{APITag.TRANSACTIONS}, "transactionJSON", "transactionBytes", "prunableAttachmentJSON", "minBundlerBalanceFXT", "minBundlerFeeLimitFQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        String string = Convert.emptyToNull(httpServletRequest.getParameter("transactionJSON"));
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("transactionBytes"));
        String string3 = Convert.emptyToNull(httpServletRequest.getParameter("prunableAttachmentJSON"));
        long l = ParameterParser.getLong(httpServletRequest, "minBundlerBalanceFXT", 0L, 1000000000L, Constants.minBundlerBalanceFXT);
        long l2 = ParameterParser.getLong(httpServletRequest, "minBundlerFeeLimitFQT", 0L, 100000000000000000L, (long)Constants.minBundlerFeeLimitFXT * 100000000L);
        JSONObject jSONObject = new JSONObject();
        try {
            Transaction.Builder builder = ParameterParser.parseTransaction(string, string2, string3);
            Transaction transaction = builder.build();
            long l3 = transaction.getMinimumFeeFQT();
            jSONObject.put((Object)"minimumFeeFQT", (Object)String.valueOf(l3));
            if (transaction.getChain() == FxtChain.FXT) {
                jSONObject.put((Object)"feeNQT", (Object)String.valueOf(l3));
            } else {
                long l4 = Peers.getBestBundlerRate(transaction.getChain(), l, Math.max(l3, l2), Peers.getBestBundlerRateWhitelist());
                BigInteger[] bigIntegerArray = BigInteger.valueOf(l3).multiply(BigInteger.valueOf(l4)).divideAndRemainder(Constants.ONE_FXT_BIG_INTEGER);
                long l5 = bigIntegerArray[0].longValueExact() + (long)(bigIntegerArray[1].equals(BigInteger.ZERO) ? 0 : 1);
                jSONObject.put((Object)"feeNQT", (Object)String.valueOf(l5));
            }
        }
        catch (NxtException.NotValidException notValidException) {
            JSONData.putException(jSONObject, notValidException, "Incorrect transaction json or bytes");
        }
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

