/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.ae.AskOrderCancellationAttachment;
import nxt.ae.OrderHome;
import nxt.blockchain.ChildChain;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class CancelAskOrder
extends CreateTransaction {
    static final CancelAskOrder instance = new CancelAskOrder();

    private CancelAskOrder() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "order");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "order", true);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        OrderHome.Ask ask = childChain.getOrderHome().getAskOrder(l);
        if (ask == null || ask.getAccountId() != account.getId()) {
            return JSONResponses.UNKNOWN_ORDER;
        }
        AskOrderCancellationAttachment askOrderCancellationAttachment = new AskOrderCancellationAttachment(ask.getFullHash());
        return this.createTransaction(httpServletRequest, account, askOrderCancellationAttachment);
    }
}

