/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.dgs.DelistingAttachment;
import nxt.dgs.DigitalGoodsHome;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class DGSDelisting
extends CreateTransaction {
    static final DGSDelisting instance = new DGSDelisting();

    private DGSDelisting() {
        super(new APITag[]{APITag.DGS, APITag.CREATE_TRANSACTION}, "goods");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        DigitalGoodsHome.Goods goods = ParameterParser.getGoods(httpServletRequest);
        if (goods.isDelisted() || goods.getSellerId() != account.getId()) {
            return JSONResponses.UNKNOWN_GOODS;
        }
        DelistingAttachment delistingAttachment = new DelistingAttachment(goods.getId());
        return this.createTransaction(httpServletRequest, account, delistingAttachment);
    }
}

