/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.dgs.DigitalGoodsHome;
import nxt.dgs.PurchaseAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class DGSPurchase
extends CreateTransaction {
    static final DGSPurchase instance = new DGSPurchase();

    private DGSPurchase() {
        super(new APITag[]{APITag.DGS, APITag.CREATE_TRANSACTION}, "goods", "priceNQT", "quantity", "deliveryDeadlineTimestamp");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n;
        DigitalGoodsHome.Goods goods = ParameterParser.getGoods(httpServletRequest);
        if (goods.isDelisted()) {
            return JSONResponses.UNKNOWN_GOODS;
        }
        int n2 = ParameterParser.getGoodsQuantity(httpServletRequest);
        if (n2 > goods.getQuantity()) {
            return JSONResponses.INCORRECT_PURCHASE_QUANTITY;
        }
        long l = ParameterParser.getPriceNQT(httpServletRequest);
        if (l != goods.getPriceNQT()) {
            return JSONResponses.INCORRECT_PURCHASE_PRICE;
        }
        String string = Convert.emptyToNull(httpServletRequest.getParameter("deliveryDeadlineTimestamp"));
        if (string == null) {
            return JSONResponses.MISSING_DELIVERY_DEADLINE_TIMESTAMP;
        }
        try {
            n = Integer.parseInt(string);
            if (n <= Nxt.getEpochTime()) {
                return JSONResponses.INCORRECT_DELIVERY_DEADLINE_TIMESTAMP;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return JSONResponses.INCORRECT_DELIVERY_DEADLINE_TIMESTAMP;
        }
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Account account2 = Account.getAccount(goods.getSellerId());
        PurchaseAttachment purchaseAttachment = new PurchaseAttachment(goods.getId(), n2, l, n);
        try {
            return this.transactionParameters(httpServletRequest, account, purchaseAttachment).setRecipientId(account2.getId()).createTransaction();
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }
}

