/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountPropertyDeleteAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class DeleteAccountProperty
extends CreateTransaction {
    static final DeleteAccountProperty instance = new DeleteAccountProperty();

    private DeleteAccountProperty() {
        super(new APITag[]{APITag.ACCOUNTS, APITag.CREATE_TRANSACTION}, "recipient", "property", "setter");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        String string;
        long l;
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        long l2 = ParameterParser.getAccountId(httpServletRequest, "recipient", false);
        if (l2 == 0L) {
            l2 = account.getId();
        }
        if ((l = ParameterParser.getAccountId(httpServletRequest, "setter", false)) == 0L) {
            l = account.getId();
        }
        if ((string = Convert.nullToEmpty(httpServletRequest.getParameter("property")).trim()).isEmpty()) {
            return JSONResponses.MISSING_PROPERTY;
        }
        Account.AccountProperty accountProperty = Account.getProperty(l2, string, l);
        if (accountProperty == null) {
            return JSONResponses.UNKNOWN_PROPERTY;
        }
        if (accountProperty.getRecipientId() != account.getId() && accountProperty.getSetterId() != account.getId()) {
            return JSONResponses.INCORRECT_PROPERTY;
        }
        AccountPropertyDeleteAttachment accountPropertyDeleteAttachment = new AccountPropertyDeleteAttachment(accountProperty.getId());
        return this.transactionParameters(httpServletRequest, account, accountPropertyDeleteAttachment).setRecipientId(l2).createTransaction();
    }

    @Override
    public boolean isIgnisOnly() {
        return true;
    }
}

