/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.HoldingType;
import nxt.ae.Asset;
import nxt.ae.DividendPaymentAttachment;
import nxt.blockchain.ChildChain;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public class DividendPayment
extends CreateTransaction {
    static final DividendPayment instance = new DividendPayment();

    private DividendPayment() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "holding", "holdingType", "asset", "height", "amountNQTPerShare");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        int n = ParameterParser.getHeight(httpServletRequest, true);
        long l = ParameterParser.getAmountNQTPerShare(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        if (Asset.getAsset(asset.getId(), n) == null) {
            return JSONResponses.ASSET_NOT_ISSUED_YET;
        }
        HoldingType holdingType = ParameterParser.getHoldingType(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        long l2 = holdingType != HoldingType.COIN ? ParameterParser.getHoldingId(httpServletRequest) : (long)childChain.getId();
        DividendPaymentAttachment dividendPaymentAttachment = new DividendPaymentAttachment(l2, holdingType, asset.getId(), n, l);
        try {
            return this.createTransaction(httpServletRequest, account, dividendPaymentAttachment);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_FUNDS;
        }
    }
}

