/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.EventListener;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class EventRegister
extends APIServlet.APIRequestHandler {
    static final EventRegister instance = new EventRegister();
    private static final JSONObject exclusiveParams = new JSONObject();
    private static final JSONObject incorrectEvent;
    private static final JSONObject unknownEvent;
    private static final JSONObject noEventsRegistered;
    private static final AtomicLong nextToken;

    private EventRegister() {
        super(new APITag[]{APITag.INFO}, "event", "event", "event", "token", "add", "remove");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        JSONObject jSONObject = null;
        long l = ParameterParser.getLong(httpServletRequest, "token", 0L, Long.MAX_VALUE, false);
        boolean bl = Boolean.valueOf(httpServletRequest.getParameter("add"));
        boolean bl2 = Boolean.valueOf(httpServletRequest.getParameter("remove"));
        if (bl && bl2) {
            return exclusiveParams;
        }
        ArrayList<EventListener.EventRegistration> arrayList = new ArrayList<EventListener.EventRegistration>();
        String[] stringArray = httpServletRequest.getParameterValues("event");
        if (stringArray == null) {
            EventListener.peerEvents.forEach(event -> arrayList.add(new EventListener.EventRegistration((Enum<? extends Enum>)event, 0L)));
            EventListener.blockEvents.forEach(event -> arrayList.add(new EventListener.EventRegistration((Enum<? extends Enum>)event, 0L)));
            EventListener.txEvents.forEach(event -> arrayList.add(new EventListener.EventRegistration((Enum<? extends Enum>)event, 0L)));
            EventListener.ledgerEvents.forEach(event -> arrayList.add(new EventListener.EventRegistration((Enum<? extends Enum>)event, 0L)));
        } else {
            for (String string : stringArray) {
                List<Enum> list;
                long l2 = 0L;
                String[] stringArray2 = string.split("\\.");
                switch (stringArray2[0]) {
                    case "Ledger": 
                    case "Transaction": {
                        if (stringArray2.length == 3) {
                            try {
                                l2 = Convert.parseAccountId(stringArray2[2]);
                                break;
                            }
                            catch (RuntimeException runtimeException) {
                                return incorrectEvent;
                            }
                        }
                        if (stringArray2.length == 2) break;
                        return incorrectEvent;
                    }
                    default: {
                        if (stringArray2.length == 2) break;
                        return incorrectEvent;
                    }
                }
                switch (stringArray2[0]) {
                    case "Block": {
                        list = EventListener.blockEvents;
                        break;
                    }
                    case "Peer": {
                        list = EventListener.peerEvents;
                        break;
                    }
                    case "Transaction": {
                        list = EventListener.txEvents;
                        break;
                    }
                    case "Ledger": {
                        list = EventListener.ledgerEvents;
                        break;
                    }
                    default: {
                        return unknownEvent;
                    }
                }
                int n = 0;
                for (Enum enum_ : list) {
                    if (!enum_.name().equals(stringArray2[1])) continue;
                    arrayList.add(new EventListener.EventRegistration(enum_, l2));
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                return unknownEvent;
            }
        }
        try {
            if (l == 0L) {
                l = nextToken.incrementAndGet();
                String eventListenerException = httpServletRequest.getRemoteAddr() + ";" + l;
                EventListener eventListener = new EventListener(eventListenerException);
                eventListener.activateListener(arrayList);
            } else {
                String string = httpServletRequest.getRemoteAddr() + ";" + l;
                EventListener eventListener = EventListener.eventListeners.get(string);
                if (eventListener == null) {
                    return noEventsRegistered;
                }
                if (bl || bl2) {
                    if (bl) {
                        eventListener.addEvents(arrayList);
                    } else {
                        eventListener.removeEvents(arrayList);
                    }
                } else {
                    eventListener = new EventListener(string);
                    eventListener.activateListener(arrayList);
                }
            }
        }
        catch (EventListener.EventListenerException eventListenerException) {
            jSONObject = new JSONObject();
            jSONObject.put((Object)"errorCode", (Object)7);
            jSONObject.put((Object)"errorDescription", (Object)("Unable to register events: " + eventListenerException.getMessage()));
        }
        if (jSONObject == null) {
            jSONObject = new JSONObject();
            jSONObject.put((Object)"registered", (Object)true);
            jSONObject.put((Object)"token", (Object)Long.toUnsignedString(l));
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }

    static {
        exclusiveParams.put((Object)"errorCode", (Object)4);
        exclusiveParams.put((Object)"errorDescription", (Object)"Mutually exclusive 'add' and 'remove'");
        incorrectEvent = new JSONObject();
        incorrectEvent.put((Object)"errorCode", (Object)4);
        incorrectEvent.put((Object)"errorDescription", (Object)"Incorrect event name format");
        unknownEvent = new JSONObject();
        unknownEvent.put((Object)"errorCode", (Object)5);
        unknownEvent.put((Object)"errorDescription", (Object)"Unknown event name");
        noEventsRegistered = new JSONObject();
        noEventsRegistered.put((Object)"errorCode", (Object)8);
        noEventsRegistered.put((Object)"errorDescription", (Object)"No events registered");
        nextToken = new AtomicLong();
    }
}

