/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.EventListener;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class EventWait
extends APIServlet.APIRequestHandler {
    static final EventWait instance = new EventWait();
    private static final JSONObject noEventsRegistered = new JSONObject();

    private EventWait() {
        super(new APITag[]{APITag.INFO}, "token", "timeout");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        JSONObject jSONObject = null;
        long l = ParameterParser.getLong(httpServletRequest, "token", 1L, Long.MAX_VALUE, true);
        long l2 = ParameterParser.getLong(httpServletRequest, "timeout", 1L, Long.MAX_VALUE, false);
        long l3 = l2 = l2 == 0L ? (long)EventListener.eventTimeout : Math.min(l2, (long)EventListener.eventTimeout);
        if (jSONObject == null) {
            String string = httpServletRequest.getRemoteAddr() + ";" + l;
            EventListener eventListener = EventListener.eventListeners.get(string);
            if (eventListener == null) {
                jSONObject = noEventsRegistered;
            } else {
                try {
                    List<EventListener.PendingEvent> list = eventListener.eventWait(httpServletRequest, l2);
                    if (list != null) {
                        jSONObject = EventWait.formatResponse(list);
                    }
                }
                catch (EventListener.EventListenerException eventListenerException) {
                    jSONObject = new JSONObject();
                    jSONObject.put((Object)"errorCode", (Object)7);
                    jSONObject.put((Object)"errorDescription", (Object)("Unable to wait for an event: " + eventListenerException.getMessage()));
                }
            }
        }
        return jSONObject;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }

    static JSONObject formatResponse(List<EventListener.PendingEvent> list) {
        JSONArray jSONArray = new JSONArray();
        list.forEach(pendingEvent -> {
            JSONArray jSONArray2 = new JSONArray();
            if (pendingEvent.isList()) {
                jSONArray2.addAll(pendingEvent.getIdList());
            } else {
                jSONArray2.add((Object)pendingEvent.getId());
            }
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"name", (Object)pendingEvent.getName());
            jSONObject.put((Object)"ids", (Object)jSONArray2);
            jSONArray.add((Object)jSONObject);
        });
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"events", (Object)jSONArray);
        return jSONObject;
    }

    static {
        noEventsRegistered.put((Object)"errorCode", (Object)8);
        noEventsRegistered.put((Object)"errorDescription", (Object)"No events registered");
    }
}

