/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.AccountLedger;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetAccountLedger
extends APIServlet.APIRequestHandler {
    static final GetAccountLedger instance = new GetAccountLedger();

    private GetAccountLedger() {
        super(new APITag[]{APITag.ACCOUNTS}, "account", "firstIndex", "lastIndex", "eventType", "event", "holdingType", "holding", "includeTransactions", "includeHoldingInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, "account", false);
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        String string = Convert.emptyToNull(httpServletRequest.getParameter("eventType"));
        AccountLedger.LedgerEvent ledgerEvent = null;
        long l2 = 0L;
        if (string != null) {
            try {
                ledgerEvent = AccountLedger.LedgerEvent.valueOf(string);
                l2 = ParameterParser.getUnsignedLong(httpServletRequest, "event", false);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.incorrect("eventType"));
            }
        }
        String string2 = Convert.emptyToNull(httpServletRequest.getParameter("holdingType"));
        AccountLedger.LedgerHolding ledgerHolding = null;
        long l3 = 0L;
        if (string2 != null) {
            try {
                ledgerHolding = AccountLedger.LedgerHolding.valueOf(string2);
                l3 = ParameterParser.getUnsignedLong(httpServletRequest, "holding", false);
            }
            catch (RuntimeException runtimeException) {
                throw new ParameterException(JSONResponses.incorrect("holdingType"));
            }
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeTransactions"));
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeHoldingInfo"));
        List<AccountLedger.LedgerEntry> list = AccountLedger.getEntries(l, ledgerEvent, l2, ledgerHolding, l3, n, n2);
        JSONArray jSONArray = new JSONArray();
        list.forEach(ledgerEntry -> {
            JSONObject jSONObject = new JSONObject();
            JSONData.ledgerEntry(jSONObject, ledgerEntry, bl, bl2);
            jSONArray.add((Object)jSONObject);
        });
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"entries", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

