/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.peer.BundlerRate;
import nxt.peer.Peers;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetAllBundlerRates
extends APIServlet.APIRequestHandler {
    static final GetAllBundlerRates instance = new GetAllBundlerRates();

    private GetAllBundlerRates() {
        super(new APITag[]{APITag.FORGING}, "minBundlerBalanceFXT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getLong(httpServletRequest, "minBundlerBalanceFXT", 0L, 1000000000L, false);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        List<BundlerRate> list = Peers.getAllBundlerRates(l);
        ChildChain.getAll().forEach(childChain -> {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"chain", (Object)childChain.getId());
            JSONArray jSONArray2 = new JSONArray();
            list.forEach(bundlerRate -> {
                if (bundlerRate.getChain() == childChain) {
                    JSONObject jSONObject = new JSONObject();
                    JSONData.putAccount(jSONObject, "account", bundlerRate.getAccountId());
                    jSONObject.put((Object)"minRateNQTPerFXT", (Object)String.valueOf(bundlerRate.getRate()));
                    jSONObject.put((Object)"currentFeeLimitFQT", (Object)String.valueOf(bundlerRate.getFeeLimit()));
                    jSONArray2.add((Object)jSONObject);
                }
            });
            jSONObject.put((Object)"rates", (Object)jSONArray2);
            jSONArray.add((Object)jSONObject);
        });
        jSONObject.put((Object)"rates", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

