/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.ae.AssetDividendHome;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetAssetDividends
extends APIServlet.APIRequestHandler {
    static final GetAssetDividends instance = new GetAssetDividends();

    private GetAssetDividends() {
        super(new APITag[]{APITag.AE}, "asset", "firstIndex", "lastIndex", "timestamp", "includeHoldingInfo");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "asset", false);
        int n = ParameterParser.getTimestamp(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeHoldingInfo"));
        int n2 = ParameterParser.getFirstIndex(httpServletRequest);
        int n3 = ParameterParser.getLastIndex(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try (DbIterator<AssetDividendHome.AssetDividend> dbIterator = childChain.getAssetDividendHome().getAssetDividends(l, n2, n3);){
            while (dbIterator.hasNext()) {
                AssetDividendHome.AssetDividend assetDividend = dbIterator.next();
                if (assetDividend.getTimestamp() < n) {
                    break;
                }
                jSONArray.add((Object)JSONData.assetDividend(assetDividend, bl));
            }
        }
        jSONObject.put((Object)"dividends", (Object)jSONArray);
        return jSONObject;
    }
}

