/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetBlockchainTransactions
extends APIServlet.APIRequestHandler {
    static final GetBlockchainTransactions instance = new GetBlockchainTransactions();

    private GetBlockchainTransactions() {
        super(new APITag[]{APITag.ACCOUNTS, APITag.TRANSACTIONS}, "account", "timestamp", "type", "subtype", "firstIndex", "lastIndex", "numberOfConfirmations", "withMessage", "phasedOnly", "nonPhasedOnly", "includeExpiredPrunable", "includePhasingResult", "executedOnly");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        DbIterator<Transaction> dbIterator;
        byte by;
        byte by2;
        long l = ParameterParser.getAccountId(httpServletRequest, true);
        int n = ParameterParser.getTimestamp(httpServletRequest);
        int n2 = ParameterParser.getNumberOfConfirmations(httpServletRequest);
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("withMessage"));
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("phasedOnly"));
        boolean bl3 = "true".equalsIgnoreCase(httpServletRequest.getParameter("nonPhasedOnly"));
        boolean bl4 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeExpiredPrunable"));
        boolean bl5 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includePhasingResult"));
        boolean bl6 = "true".equalsIgnoreCase(httpServletRequest.getParameter("executedOnly"));
        Chain chain = ParameterParser.getChain(httpServletRequest);
        try {
            by2 = Byte.parseByte(httpServletRequest.getParameter("type"));
        }
        catch (NumberFormatException numberFormatException) {
            by2 = chain instanceof ChildChain ? (byte)-1 : 1;
        }
        try {
            by = Byte.parseByte(httpServletRequest.getParameter("subtype"));
        }
        catch (NumberFormatException numberFormatException) {
            by = -1;
        }
        int n3 = ParameterParser.getFirstIndex(httpServletRequest);
        int n4 = ParameterParser.getLastIndex(httpServletRequest);
        JSONArray jSONArray = new JSONArray();
        if (chain instanceof ChildChain) {
            dbIterator = Nxt.getBlockchain().getTransactions((ChildChain)chain, l, n2, by2, by, n, bl, bl2, bl3, n3, n4, bl4, bl6);
            Throwable throwable = null;
            try {
                while (dbIterator.hasNext()) {
                    Transaction transaction = dbIterator.next();
                    jSONArray.add((Object)JSONData.transaction(transaction, bl5));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dbIterator != null) {
                    if (throwable != null) {
                        try {
                            dbIterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dbIterator.close();
                    }
                }
            }
        }
        dbIterator = Nxt.getBlockchain().getTransactions((FxtChain)chain, l, n2, by2, by, n, n3, n4);
        Throwable throwable = null;
        try {
            while (dbIterator.hasNext()) {
                Transaction transaction = dbIterator.next();
                jSONArray.add((Object)JSONData.transaction(transaction));
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (dbIterator != null) {
                if (throwable != null) {
                    try {
                        dbIterator.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    dbIterator.close();
                }
            }
        }
        dbIterator = new JSONObject();
        dbIterator.put("transactions", jSONArray);
        return dbIterator;
    }
}

