/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Constants;
import nxt.NxtException;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.peer.BundlerRate;
import nxt.peer.Peers;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetBundlerRates
extends APIServlet.APIRequestHandler {
    static final GetBundlerRates instance = new GetBundlerRates();

    private GetBundlerRates() {
        super(new APITag[]{APITag.FORGING}, "minBundlerBalanceFXT", "minBundlerFeeLimitFQT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getLong(httpServletRequest, "minBundlerBalanceFXT", 0L, 1000000000L, Constants.minBundlerBalanceFXT);
        long l2 = ParameterParser.getLong(httpServletRequest, "minBundlerFeeLimitFQT", 0L, 100000000000000000L, (long)Constants.minBundlerFeeLimitFXT * 100000000L);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        List<BundlerRate> list = Peers.getBestBundlerRates(l, l2, Peers.getBestBundlerRateWhitelist());
        list.forEach(bundlerRate -> {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"chain", (Object)bundlerRate.getChain().getId());
            JSONData.putAccount(jSONObject, "account", bundlerRate.getAccountId());
            jSONObject.put((Object)"minRateNQTPerFXT", (Object)String.valueOf(bundlerRate.getRate()));
            jSONObject.put((Object)"currentFeeLimitFQT", (Object)String.valueOf(bundlerRate.getFeeLimit()));
            jSONArray.add((Object)jSONObject);
        });
        jSONObject.put((Object)"rates", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

