/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.db.DbUtils;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.ms.CurrencyFounderHome;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetCurrencyFounders
extends APIServlet.APIRequestHandler {
    static final GetCurrencyFounders instance = new GetCurrencyFounders();

    private GetCurrencyFounders() {
        super(new APITag[]{APITag.MS}, "currency", "account", "firstIndex", "lastIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getUnsignedLong(httpServletRequest, "currency", false);
        long l2 = ParameterParser.getAccountId(httpServletRequest, false);
        if (l == 0L && l2 == 0L) {
            return JSONResponses.MISSING_CURRENCY_ACCOUNT;
        }
        int n = ParameterParser.getFirstIndex(httpServletRequest);
        int n2 = ParameterParser.getLastIndex(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"founders", (Object)jSONArray);
        if (l != 0L && l2 != 0L) {
            CurrencyFounderHome.CurrencyFounder currencyFounder = childChain.getCurrencyFounderHome().getFounder(l, l2);
            if (currencyFounder != null) {
                jSONArray.add((Object)JSONData.currencyFounder(currencyFounder));
            }
            return jSONObject;
        }
        DbIterator<CurrencyFounderHome.CurrencyFounder> dbIterator = null;
        try {
            if (l2 == 0L) {
                dbIterator = childChain.getCurrencyFounderHome().getCurrencyFounders(l, n, n2);
            } else if (l == 0L) {
                dbIterator = childChain.getCurrencyFounderHome().getFounderCurrencies(l2, n, n2);
            }
            for (CurrencyFounderHome.CurrencyFounder currencyFounder : dbIterator) {
                jSONArray.add((Object)JSONData.currencyFounder(currencyFounder));
            }
        }
        catch (Throwable throwable) {
            DbUtils.close(dbIterator);
            throw throwable;
        }
        DbUtils.close(dbIterator);
        return jSONObject;
    }
}

