/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.blockchain.Transaction;
import nxt.ce.CoinExchange;
import nxt.ce.CoinExchangeFxtTransactionType;
import nxt.ce.CoinExchangeTransactionType;
import nxt.ce.OrderCancelAttachment;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedCoinExchangeOrderCancellations
extends APIServlet.APIRequestHandler {
    static final GetExpectedCoinExchangeOrderCancellations instance = new GetExpectedCoinExchangeOrderCancellations();

    private GetExpectedCoinExchangeOrderCancellations() {
        super(new APITag[]{APITag.CE}, new String[0]);
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Chain chain = ParameterParser.getChain(httpServletRequest, "chain", false);
        Chain chain2 = ParameterParser.getChain(httpServletRequest, "exchange", false);
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != CoinExchangeTransactionType.ORDER_CANCEL && transaction.getType() != CoinExchangeFxtTransactionType.ORDER_CANCEL) {
                return false;
            }
            OrderCancelAttachment orderCancelAttachment = (OrderCancelAttachment)transaction.getAttachment();
            CoinExchange.Order order = CoinExchange.getOrder(orderCancelAttachment.getOrderId());
            if (order == null) {
                return false;
            }
            if (chain != null && order.getChainId() != chain.getId()) {
                return false;
            }
            return chain2 == null || order.getExchangeId() == chain2.getId();
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add((Object)JSONData.expectedCoinExchangeOrderCancellation(transaction)));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"orderCancellations", (Object)jSONArray);
        return jSONObject;
    }
}

