/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.ae.AssetExchangeTransactionType;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.util.Filter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetExpectedOrderCancellations
extends APIServlet.APIRequestHandler {
    static final GetExpectedOrderCancellations instance = new GetExpectedOrderCancellations();

    private GetExpectedOrderCancellations() {
        super(new APITag[]{APITag.AE}, new String[0]);
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest, false);
        Filter<Transaction> filter = transaction -> {
            if (transaction.getType() != AssetExchangeTransactionType.ASK_ORDER_CANCELLATION && transaction.getType() != AssetExchangeTransactionType.BID_ORDER_CANCELLATION) {
                return false;
            }
            return childChain == null || transaction.getChain() == childChain;
        };
        List<? extends Transaction> list = Nxt.getBlockchain().getExpectedTransactions(filter);
        JSONArray jSONArray = new JSONArray();
        list.forEach(transaction -> jSONArray.add((Object)JSONData.expectedOrderCancellation(transaction)));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"orderCancellations", (Object)jSONArray);
        return jSONObject;
    }
}

