/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Block;
import nxt.blockchain.Blockchain;
import nxt.blockchain.Generator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetNextBlockGenerators
extends APIServlet.APIRequestHandler {
    static final GetNextBlockGenerators instance = new GetNextBlockGenerators();

    private GetNextBlockGenerators() {
        super(new APITag[]{APITag.FORGING}, "limit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        JSONObject jSONObject = new JSONObject();
        int n = Math.max(1, ParameterParser.getInt(httpServletRequest, "limit", 1, Integer.MAX_VALUE, false));
        Blockchain blockchain = Nxt.getBlockchain();
        blockchain.readLock();
        try {
            Block block = blockchain.getLastBlock();
            jSONObject.put((Object)"timestamp", (Object)block.getTimestamp());
            jSONObject.put((Object)"height", (Object)block.getHeight());
            jSONObject.put((Object)"lastBlock", (Object)Long.toUnsignedString(block.getId()));
            List<Generator.ActiveGenerator> list = Generator.getNextGenerators();
            jSONObject.put((Object)"activeCount", (Object)list.size());
            JSONArray jSONArray = new JSONArray();
            for (Generator.ActiveGenerator activeGenerator : list) {
                if (activeGenerator.getHitTime() > Integer.MAX_VALUE) break;
                JSONObject jSONObject2 = new JSONObject();
                JSONData.putAccount(jSONObject2, "account", activeGenerator.getAccountId());
                jSONObject2.put((Object)"effectiveBalanceFXT", (Object)activeGenerator.getEffectiveBalance());
                jSONObject2.put((Object)"hitTime", (Object)activeGenerator.getHitTime());
                jSONObject2.put((Object)"deadline", (Object)((int)activeGenerator.getHitTime() - block.getTimestamp()));
                jSONArray.add((Object)jSONObject2);
                if (jSONArray.size() != n) continue;
                break;
            }
            jSONObject.put((Object)"generators", (Object)jSONArray);
        }
        finally {
            blockchain.readUnlock();
        }
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

