/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetPeers
extends APIServlet.APIRequestHandler {
    static final GetPeers instance = new GetPeers();

    private GetPeers() {
        super(new APITag[]{APITag.NETWORK}, "active", "state", "service", "service", "service", "includePeerInfo", "version", "includeNewer", "connect", "adminPassword");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        boolean bl;
        Peer.State state;
        boolean bl2 = "true".equalsIgnoreCase(httpServletRequest.getParameter("active"));
        String string = Convert.emptyToNull(httpServletRequest.getParameter("state"));
        String[] stringArray = httpServletRequest.getParameterValues("service");
        boolean bl3 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includePeerInfo"));
        boolean bl4 = "true".equalsIgnoreCase(httpServletRequest.getParameter("includeNewer"));
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("version"));
        int[] nArray = string2.equals("") ? new int[]{0, 0, 0} : Arrays.stream(string2.endsWith("e") ? string2.substring(0, string2.length() - 1).split("\\.") : string2.split("\\.")).mapToInt(Integer::parseInt).toArray();
        if (string != null) {
            try {
                state = Peer.State.valueOf(string);
            }
            catch (RuntimeException runtimeException) {
                return JSONResponses.incorrect("state", "- '" + string + "' is not defined");
            }
        } else {
            state = null;
        }
        long l = 0L;
        if (stringArray != null) {
            for (String string3 : stringArray) {
                try {
                    l |= Peer.Service.valueOf(string3).getCode();
                }
                catch (RuntimeException runtimeException) {
                    return JSONResponses.incorrect("service", "- '" + string3 + "' is not defined");
                }
            }
        }
        boolean bl5 = bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("connect")) && API.checkPassword(httpServletRequest);
        if (bl) {
            if (!Peers.isNetworkingEnabled()) {
                return JSONResponses.PEERS_NETWORKING_DISABLED;
            }
            ArrayList arrayList = new ArrayList();
            Peers.getAllPeers().forEach(peer -> arrayList.add(() -> {
                peer.connectPeer();
                return null;
            }));
            ExecutorService executorService = Executors.newFixedThreadPool(10);
            try {
                executorService.invokeAll(arrayList);
            }
            catch (InterruptedException interruptedException) {
                Logger.logMessage(interruptedException.toString(), interruptedException);
            }
        }
        Collection<Peer> collection = bl2 ? Peers.getPeers(peer -> peer.getState() != Peer.State.NON_CONNECTED) : (state != null ? Peers.getPeers(peer -> peer.getState() == state) : Peers.getAllPeers());
        long l2 = l;
        JSONArray jSONArray = new JSONArray();
        collection.stream().filter(peer -> string2.isEmpty() || peer.getVersion() != null && (bl4 ? !Peers.isOldVersion(peer.getVersion(), nArray) : peer.getVersion().startsWith(string2))).filter(peer -> l2 == 0L || peer.providesServices(l2)).map(peer -> bl3 ? JSONData.peer(peer) : peer.getHost()).forEach(arg_0 -> jSONArray.add(arg_0));
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"peers", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

