/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetPlugins
extends APIServlet.APIRequestHandler {
    static final GetPlugins instance = new GetPlugins();
    private static final Path PLUGINS_HOME = Paths.get("./html/www/plugins", new String[0]);

    private GetPlugins() {
        super(new APITag[]{APITag.INFO}, new String[0]);
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        JSONObject jSONObject = new JSONObject();
        if (!Files.isReadable(PLUGINS_HOME)) {
            return JSONResponses.fileNotFound(PLUGINS_HOME.toString());
        }
        PluginDirListing pluginDirListing = new PluginDirListing();
        try {
            Files.walkFileTree(PLUGINS_HOME, EnumSet.noneOf(FileVisitOption.class), 2, pluginDirListing);
        }
        catch (IOException iOException) {
            return JSONResponses.fileNotFound(iOException.getMessage());
        }
        JSONArray jSONArray = new JSONArray();
        pluginDirListing.getDirectories().forEach(path -> jSONArray.add((Object)Paths.get(path.toString(), new String[0]).getFileName().toString()));
        jSONObject.put((Object)"plugins", (Object)jSONArray);
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }

    private static class PluginDirListing
    extends SimpleFileVisitor<Path> {
        private final List<Path> directories = new ArrayList<Path>();

        private PluginDirListing() {
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
            if (!PLUGINS_HOME.equals(path)) {
                this.directories.add(path);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) {
            return FileVisitResult.CONTINUE;
        }

        public List<Path> getDirectories() {
            return this.directories;
        }
    }
}

