/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Chain;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.messaging.PrunableMessageHome;
import nxt.util.JSON;
import org.json.simple.JSONStreamAware;

public final class GetPrunableMessage
extends APIServlet.APIRequestHandler {
    static final GetPrunableMessage instance = new GetPrunableMessage();

    private GetPrunableMessage() {
        super(new APITag[]{APITag.MESSAGES}, "transactionFullHash", "secretPhrase", "sharedKey", "retrieve");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "transactionFullHash", true);
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        byte[] byArray2 = ParameterParser.getBytes(httpServletRequest, "sharedKey", false);
        if (byArray2.length != 0 && string != null) {
            return JSONResponses.either("secretPhrase", "sharedKey");
        }
        boolean bl = "true".equalsIgnoreCase(httpServletRequest.getParameter("retrieve"));
        Chain chain = ParameterParser.getChain(httpServletRequest);
        PrunableMessageHome prunableMessageHome = chain.getPrunableMessageHome();
        PrunableMessageHome.PrunableMessage prunableMessage = prunableMessageHome.getPrunableMessage(byArray);
        if (prunableMessage == null && bl) {
            if (Nxt.getBlockchainProcessor().restorePrunedTransaction(chain, byArray) == null) {
                return JSONResponses.PRUNED_TRANSACTION;
            }
            prunableMessage = prunableMessageHome.getPrunableMessage(byArray);
        }
        if (prunableMessage != null) {
            return JSONData.prunableMessage(prunableMessage, string, byArray2);
        }
        return JSON.emptyJSON;
    }
}

