/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.blockchain.ChildChain;
import nxt.db.DbIterator;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.ParameterParser;
import nxt.shuffling.ShufflingParticipantHome;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetShufflingParticipants
extends APIServlet.APIRequestHandler {
    static final GetShufflingParticipants instance = new GetShufflingParticipants();

    private GetShufflingParticipants() {
        super(new APITag[]{APITag.SHUFFLING}, "shufflingFullHash");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "shufflingFullHash", true);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"participants", (Object)jSONArray);
        try (DbIterator<ShufflingParticipantHome.ShufflingParticipant> dbIterator = childChain.getShufflingParticipantHome().getParticipants(byArray);){
            for (ShufflingParticipantHome.ShufflingParticipant shufflingParticipant : dbIterator) {
                jSONArray.add((Object)JSONData.participant(shufflingParticipant));
            }
        }
        return jSONObject;
    }
}

