/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class GetStackTraces
extends APIServlet.APIRequestHandler {
    static final GetStackTraces instance = new GetStackTraces();

    private GetStackTraces() {
        super(new APITag[]{APITag.DEBUG}, "depth");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
        JSONObject jSONObject;
        String string = httpServletRequest.getParameter("depth");
        int n = string != null ? Math.max(Integer.valueOf(string), 1) : Integer.MAX_VALUE;
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        boolean bl = threadMXBean.isObjectMonitorUsageSupported();
        for (ThreadInfo threadInfo : jSONObject = threadMXBean.dumpAllThreads(bl, false)) {
            void var19_22;
            Object object;
            MonitorInfo[] monitorInfoArray;
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put((Object)"id", (Object)threadInfo.getThreadId());
            jSONObject2.put((Object)"name", (Object)threadInfo.getThreadName());
            jSONObject2.put((Object)"state", (Object)threadInfo.getThreadState().toString());
            if (bl) {
                monitorInfoArray = threadInfo.getLockedMonitors();
                if (monitorInfoArray.length > 0) {
                    object = new JSONArray();
                    for (JSONObject object2 : monitorInfoArray) {
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put((Object)"name", (Object)object2.getClassName());
                        jSONObject3.put((Object)"hash", (Object)object2.getIdentityHashCode());
                        jSONObject3.put((Object)"depth", (Object)object2.getLockedStackDepth());
                        jSONObject3.put((Object)"trace", (Object)object2.getLockedStackFrame().toString());
                        object.add((Object)jSONObject3);
                    }
                    jSONObject2.put((Object)"locks", object);
                }
                if (threadInfo.getThreadState() == Thread.State.BLOCKED && (object = threadInfo.getLockInfo()) != null) {
                    MonitorInfo[] monitorInfoArray2 = new JSONObject();
                    monitorInfoArray2.put((Object)"name", (Object)((LockInfo)object).getClassName());
                    monitorInfoArray2.put((Object)"hash", (Object)((LockInfo)object).getIdentityHashCode());
                    monitorInfoArray2.put((Object)"thread", (Object)threadInfo.getLockOwnerId());
                    jSONObject2.put((Object)"blocked", (Object)monitorInfoArray2);
                    int n2 = 1;
                    for (Object e : jSONArray2) {
                        if (!((JSONObject)e).get((Object)"name").equals(((LockInfo)object).getClassName())) continue;
                        n2 = 0;
                        break;
                    }
                    if (n2 != 0) {
                        jSONArray2.add((Object)monitorInfoArray2);
                    }
                }
            }
            monitorInfoArray = threadInfo.getStackTrace();
            object = new JSONArray();
            int n3 = 0;
            MonitorInfo[] monitorInfoArray2 = monitorInfoArray;
            int n2 = monitorInfoArray2.length;
            boolean bl2 = false;
            while (var19_22 < n2) {
                JSONObject jSONObject4 = monitorInfoArray2[var19_22];
                object.add((Object)jSONObject4.toString());
                if (++n3 == n) break;
                ++var19_22;
            }
            jSONObject2.put((Object)"trace", object);
            jSONArray.add((Object)jSONObject2);
        }
        JSONObject jSONObject4 = new JSONObject();
        jSONObject4.put((Object)"threads", (Object)jSONArray);
        jSONObject4.put((Object)"locks", (Object)jSONArray2);
        return jSONObject4;
    }

    @Override
    protected boolean requirePassword() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }
}

