/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.Account;
import nxt.account.AccountRestrictions;
import nxt.ae.Asset;
import nxt.ae.AssetTransfer;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Generator;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.GetBlockchainStatus;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.ms.Currency;
import nxt.ms.CurrencyTransfer;
import nxt.peer.NetworkHandler;
import nxt.peer.Peers;
import nxt.util.UPnP;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class GetState
extends APIServlet.APIRequestHandler {
    static final GetState instance = new GetState();

    private GetState() {
        super(new APITag[]{APITag.INFO}, "includeCounts", "adminPassword");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        Object object;
        JSONObject jSONObject = GetBlockchainStatus.instance.processRequest(httpServletRequest);
        if ("true".equalsIgnoreCase(httpServletRequest.getParameter("includeCounts")) && API.checkPassword(httpServletRequest)) {
            object = ParameterParser.getChain(httpServletRequest);
            jSONObject.put((Object)"numberOfTransactions", (Object)Nxt.getBlockchain().getTransactionCount((Chain)object));
            jSONObject.put((Object)"numberOfAccounts", (Object)Account.getCount());
            jSONObject.put((Object)"numberOfAssets", (Object)Asset.getCount());
            jSONObject.put((Object)"numberOfTransfers", (Object)AssetTransfer.getCount());
            jSONObject.put((Object)"numberOfCurrencies", (Object)Currency.getCount());
            jSONObject.put((Object)"numberOfCurrencyTransfers", (Object)CurrencyTransfer.getCount());
            jSONObject.put((Object)"numberOfPrunableMessages", (Object)((Chain)object).getPrunableMessageHome().getCount());
            jSONObject.put((Object)"numberOfAccountLeases", (Object)Account.getAccountLeaseCount());
            jSONObject.put((Object)"numberOfActiveAccountLeases", (Object)Account.getActiveLeaseCount());
            jSONObject.put((Object)"numberOfPhasingOnlyAccounts", (Object)AccountRestrictions.PhasingOnly.getCount());
            if (object instanceof ChildChain) {
                ChildChain childChain = (ChildChain)object;
                int n = childChain.getOrderHome().getAskCount();
                int n2 = childChain.getOrderHome().getBidCount();
                jSONObject.put((Object)"numberOfOrders", (Object)(n + n2));
                jSONObject.put((Object)"numberOfAskOrders", (Object)n);
                jSONObject.put((Object)"numberOfBidOrders", (Object)n2);
                jSONObject.put((Object)"numberOfTrades", (Object)childChain.getTradeHome().getCount());
                jSONObject.put((Object)"numberOfBuyOffers", (Object)childChain.getExchangeOfferHome().getBuyOfferCount());
                jSONObject.put((Object)"numberOfSellOffers", (Object)childChain.getExchangeOfferHome().getSellOfferCount());
                jSONObject.put((Object)"numberOfExchangeRequests", (Object)childChain.getExchangeRequestHome().getCount());
                jSONObject.put((Object)"numberOfExchanges", (Object)childChain.getExchangeHome().getCount());
                jSONObject.put((Object)"numberOfAliases", (Object)childChain.getAliasHome().getCount());
                jSONObject.put((Object)"numberOfGoods", (Object)childChain.getDigitalGoodsHome().getGoodsCount());
                jSONObject.put((Object)"numberOfPurchases", (Object)childChain.getDigitalGoodsHome().getPurchaseCount());
                jSONObject.put((Object)"numberOfTags", (Object)childChain.getDigitalGoodsHome().getTagCount());
                jSONObject.put((Object)"numberOfPolls", (Object)childChain.getPollHome().getCount());
                jSONObject.put((Object)"numberOfVotes", (Object)childChain.getVoteHome().getCount());
                jSONObject.put((Object)"numberOfTaggedData", (Object)childChain.getTaggedDataHome().getCount());
                jSONObject.put((Object)"numberOfDataTags", (Object)childChain.getTaggedDataHome().getTagCount());
                jSONObject.put((Object)"numberOfShufflings", (Object)childChain.getShufflingHome().getCount());
                jSONObject.put((Object)"numberOfActiveShufflings", (Object)childChain.getShufflingHome().getActiveCount());
            }
        }
        jSONObject.put((Object)"numberOfPeers", (Object)Peers.getAllPeers().size());
        jSONObject.put((Object)"numberOfConnectedPeers", (Object)NetworkHandler.getConnectionCount());
        jSONObject.put((Object)"numberOfUnlockedAccounts", (Object)Generator.getAllGenerators().size());
        jSONObject.put((Object)"availableProcessors", (Object)Runtime.getRuntime().availableProcessors());
        jSONObject.put((Object)"maxMemory", (Object)Runtime.getRuntime().maxMemory());
        jSONObject.put((Object)"totalMemory", (Object)Runtime.getRuntime().totalMemory());
        jSONObject.put((Object)"freeMemory", (Object)Runtime.getRuntime().freeMemory());
        jSONObject.put((Object)"peerPort", (Object)NetworkHandler.getDefaultPeerPort());
        jSONObject.put((Object)"isOffline", (Object)Constants.isOffline);
        jSONObject.put((Object)"needsAdminPassword", (Object)(!API.disableAdminPassword ? 1 : 0));
        jSONObject.put((Object)"customLoginWarning", (Object)Constants.customLoginWarning);
        object = UPnP.getExternalAddress();
        if (object != null) {
            jSONObject.put((Object)"upnpExternalAddress", (Object)((InetAddress)object).getHostAddress());
        }
        return jSONObject;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }
}

