/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.ae.AskOrderPlacementAttachment;
import nxt.ae.Asset;
import nxt.blockchain.ChildChain;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class PlaceAskOrder
extends CreateTransaction {
    static final PlaceAskOrder instance = new PlaceAskOrder();

    private PlaceAskOrder() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "asset", "quantityQNT", "priceNQTPerShare");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        long l = ParameterParser.getPriceNQTPerShare(httpServletRequest);
        long l2 = ParameterParser.getQuantityQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        long l3 = Convert.unitRateToAmount(l2, asset.getDecimals(), l, childChain.getDecimals());
        if (l3 == 0L) {
            return JSONResponses.NO_COST_ORDER;
        }
        AskOrderPlacementAttachment askOrderPlacementAttachment = new AskOrderPlacementAttachment(asset.getId(), l2, l);
        try {
            return this.createTransaction(httpServletRequest, account, askOrderPlacementAttachment);
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_ASSETS;
        }
    }
}

