/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONData;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public class RetrievePrunedTransaction
extends APIServlet.APIRequestHandler {
    static final RetrievePrunedTransaction instance = new RetrievePrunedTransaction();

    private RetrievePrunedTransaction() {
        super(new APITag[]{APITag.TRANSACTIONS}, "transactionFullHash");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        byte[] byArray = ParameterParser.getBytes(httpServletRequest, "transactionFullHash", true);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest);
        Transaction transaction = Nxt.getBlockchain().getTransaction(childChain, byArray);
        if (transaction == null) {
            return JSONResponses.UNKNOWN_TRANSACTION;
        }
        transaction = Nxt.getBlockchainProcessor().restorePrunedTransaction(childChain, byArray);
        if (transaction == null) {
            return JSONResponses.PRUNED_TRANSACTION;
        }
        return JSONData.transaction(transaction);
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected final boolean allowRequiredBlockParameters() {
        return false;
    }
}

