/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountInfoAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;

public final class SetAccountInfo
extends CreateTransaction {
    static final SetAccountInfo instance = new SetAccountInfo();

    private SetAccountInfo() {
        super(new APITag[]{APITag.ACCOUNTS, APITag.CREATE_TRANSACTION}, "name", "description");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        String string = Convert.nullToEmpty(httpServletRequest.getParameter("name")).trim();
        String string2 = Convert.nullToEmpty(httpServletRequest.getParameter("description")).trim();
        if (string.length() > 100) {
            return JSONResponses.INCORRECT_ACCOUNT_NAME_LENGTH;
        }
        if (string2.length() > 1000) {
            return JSONResponses.INCORRECT_ACCOUNT_DESCRIPTION_LENGTH;
        }
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        AccountInfoAttachment accountInfoAttachment = new AccountInfoAttachment(string, string2);
        return this.createTransaction(httpServletRequest, account, accountInfoAttachment);
    }

    @Override
    public boolean isIgnisOnly() {
        return true;
    }
}

