/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.peer.Peers;
import nxt.util.JSON;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class SetLogging
extends APIServlet.APIRequestHandler {
    static final SetLogging instance = new SetLogging();
    private static final JSONStreamAware LOGGING_UPDATED;
    private static final JSONStreamAware INCORRECT_LEVEL;

    private SetLogging() {
        super(new APITag[]{APITag.DEBUG}, "logLevel", "communicationLogging");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        JSONStreamAware jSONStreamAware = null;
        String string = httpServletRequest.getParameter("logLevel");
        if (string != null) {
            switch (string.toUpperCase(Locale.ROOT)) {
                case "DEBUG": {
                    Logger.setLevel(Logger.Level.DEBUG);
                    break;
                }
                case "INFO": {
                    Logger.setLevel(Logger.Level.INFO);
                    break;
                }
                case "WARN": {
                    Logger.setLevel(Logger.Level.WARN);
                    break;
                }
                case "ERROR": {
                    Logger.setLevel(Logger.Level.ERROR);
                    break;
                }
                default: {
                    jSONStreamAware = INCORRECT_LEVEL;
                    break;
                }
            }
        } else {
            Logger.setLevel(Logger.Level.INFO);
        }
        Peers.setCommunicationLogging(ParameterParser.getInt(httpServletRequest, "communicationLogging", 0, 3, false));
        if (jSONStreamAware == null) {
            jSONStreamAware = LOGGING_UPDATED;
        }
        return jSONStreamAware;
    }

    @Override
    protected boolean requirePassword() {
        return true;
    }

    @Override
    protected final boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireBlockchain() {
        return false;
    }

    @Override
    protected boolean isChainSpecific() {
        return false;
    }

    static {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"loggingUpdated", (Object)true);
        LOGGING_UPDATED = JSON.prepare(jSONObject);
        INCORRECT_LEVEL = JSONResponses.incorrect("logLevel", "Log level must be DEBUG, INFO, WARN or ERROR");
    }
}

