/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.account.Account;
import nxt.blockchain.Bundler;
import nxt.blockchain.ChildChain;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterException;
import nxt.http.ParameterParser;
import nxt.peer.Peers;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public final class StopBundler
extends APIServlet.APIRequestHandler {
    static final StopBundler instance = new StopBundler();

    private StopBundler() {
        super(new APITag[]{APITag.FORGING}, "account", "secretPhrase", "adminPassword");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws ParameterException {
        boolean bl;
        String string = ParameterParser.getSecretPhrase(httpServletRequest, false);
        long l = ParameterParser.getAccountId(httpServletRequest, false);
        ChildChain childChain = ParameterParser.getChildChain(httpServletRequest, false);
        JSONObject jSONObject = new JSONObject();
        if (string != null) {
            if (l != 0L && Account.getId(Crypto.getPublicKey(string)) != l) {
                return JSONResponses.INCORRECT_ACCOUNT;
            }
            l = Account.getId(Crypto.getPublicKey(string));
            if (childChain == null) {
                Bundler.stopAccountBundlers(l);
                jSONObject.put((Object)"stoppedAccountBundlers", (Object)true);
                bl = true;
            } else {
                Bundler bundler = Bundler.stopBundler(childChain, l);
                jSONObject.put((Object)"stoppedBundler", (Object)(bundler != null ? 1 : 0));
                bl = bundler != null;
            }
        } else {
            API.verifyPassword(httpServletRequest);
            if (l != 0L) {
                if (childChain == null) {
                    Bundler.stopAccountBundlers(l);
                    jSONObject.put((Object)"stoppedAccountBundlers", (Object)true);
                    bl = true;
                } else {
                    Bundler bundler = Bundler.stopBundler(childChain, l);
                    jSONObject.put((Object)"stoppedBundler", (Object)(bundler != null ? 1 : 0));
                    bl = bundler != null;
                }
            } else if (childChain == null) {
                Bundler.stopAllBundlers();
                jSONObject.put((Object)"stoppedAllBundlers", (Object)true);
                bl = true;
            } else {
                Bundler.stopChildChainBundlers(childChain);
                jSONObject.put((Object)"stoppedChildChainBundlers", (Object)true);
                bl = true;
            }
        }
        if (bl) {
            Peers.broadcastBundlerRates();
        }
        return jSONObject;
    }

    @Override
    protected boolean requirePost() {
        return true;
    }

    @Override
    protected boolean allowRequiredBlockParameters() {
        return false;
    }

    @Override
    protected boolean requireFullClient() {
        return true;
    }
}

