/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.ae.Asset;
import nxt.ae.AssetTransferAttachment;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import org.json.simple.JSONStreamAware;

public final class TransferAsset
extends CreateTransaction {
    static final TransferAsset instance = new TransferAsset();

    private TransferAsset() {
        super(new APITag[]{APITag.AE, APITag.CREATE_TRANSACTION}, "recipient", "asset", "quantityQNT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, "recipient", true);
        Asset asset = ParameterParser.getAsset(httpServletRequest);
        long l2 = ParameterParser.getQuantityQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        AssetTransferAttachment assetTransferAttachment = new AssetTransferAttachment(asset.getId(), l2);
        try {
            return this.transactionParameters(httpServletRequest, account, assetTransferAttachment).setRecipientId(l).createTransaction();
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_ASSETS;
        }
    }
}

