/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import javax.servlet.http.HttpServletRequest;
import nxt.NxtException;
import nxt.account.Account;
import nxt.http.APITag;
import nxt.http.CreateTransaction;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.ms.Currency;
import nxt.ms.CurrencyTransferAttachment;
import org.json.simple.JSONStreamAware;

public final class TransferCurrency
extends CreateTransaction {
    static final TransferCurrency instance = new TransferCurrency();

    private TransferCurrency() {
        super(new APITag[]{APITag.MS, APITag.CREATE_TRANSACTION}, "recipient", "currency", "unitsQNT");
    }

    @Override
    protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) throws NxtException {
        long l = ParameterParser.getAccountId(httpServletRequest, "recipient", true);
        Currency currency = ParameterParser.getCurrency(httpServletRequest);
        long l2 = ParameterParser.getUnitsQNT(httpServletRequest);
        Account account = ParameterParser.getSenderAccount(httpServletRequest);
        CurrencyTransferAttachment currencyTransferAttachment = new CurrencyTransferAttachment(currency.getId(), l2);
        try {
            return this.transactionParameters(httpServletRequest, account, currencyTransferAttachment).setRecipientId(l).createTransaction();
        }
        catch (NxtException.InsufficientBalanceException insufficientBalanceException) {
            return JSONResponses.NOT_ENOUGH_CURRENCY;
        }
    }
}

