/*
 * Decompiled with CFR 0.152.
 */
package nxt.messaging;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import nxt.Nxt;
import nxt.account.Account;
import nxt.blockchain.Chain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.PrunableDbTable;
import nxt.messaging.PrunableEncryptedMessageAppendix;
import nxt.messaging.PrunablePlainMessageAppendix;
import nxt.util.Convert;

public final class PrunableMessageHome {
    private final DbKey.HashKeyFactory<PrunableMessage> prunableMessageKeyFactory;
    private final PrunableDbTable<PrunableMessage> prunableMessageTable;
    private final Chain chain;

    public static PrunableMessageHome forChain(Chain chain) {
        if (chain.getPrunableMessageHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new PrunableMessageHome(chain);
    }

    private PrunableMessageHome(Chain chain) {
        this.chain = chain;
        this.prunableMessageKeyFactory = new DbKey.HashKeyFactory<PrunableMessage>("full_hash", "id"){

            @Override
            public DbKey newKey(PrunableMessage prunableMessage) {
                return prunableMessage.dbKey;
            }
        };
        this.prunableMessageTable = new PrunableDbTable<PrunableMessage>(chain.getSchemaTable("prunable_message"), this.prunableMessageKeyFactory){

            @Override
            protected PrunableMessage load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new PrunableMessage(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, PrunableMessage prunableMessage) throws SQLException {
                prunableMessage.save(connection);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY block_timestamp DESC, db_id DESC ";
            }
        };
    }

    public int getCount() {
        return this.prunableMessageTable.getCount();
    }

    public DbIterator<PrunableMessage> getAll(int n, int n2) {
        return this.prunableMessageTable.getAll(n, n2);
    }

    public PrunableMessage getPrunableMessage(byte[] byArray) {
        return (PrunableMessage)this.prunableMessageTable.get(this.prunableMessageKeyFactory.newKey(byArray));
    }

    public DbIterator<PrunableMessage> getPrunableMessages(long l, int n, int n2) {
        Connection connection = null;
        try {
            connection = this.prunableMessageTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM prunable_message WHERE sender_id = ? UNION ALL SELECT * FROM prunable_message WHERE recipient_id = ? AND sender_id <> ? ORDER BY block_timestamp DESC, db_id DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return this.prunableMessageTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public DbIterator<PrunableMessage> getPrunableMessages(long l, long l2, int n, int n2) {
        Connection connection = null;
        try {
            connection = this.prunableMessageTable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM prunable_message WHERE sender_id = ? AND recipient_id = ? UNION ALL SELECT * FROM prunable_message WHERE sender_id = ? AND recipient_id = ? AND sender_id <> recipient_id ORDER BY block_timestamp DESC, db_id DESC " + DbUtils.limitsClause(n, n2));
            int n3 = 0;
            preparedStatement.setLong(++n3, l);
            preparedStatement.setLong(++n3, l2);
            preparedStatement.setLong(++n3, l2);
            preparedStatement.setLong(++n3, l);
            DbUtils.setLimits(++n3, preparedStatement, n, n2);
            return this.prunableMessageTable.getManyBy(connection, preparedStatement, false);
        }
        catch (SQLException sQLException) {
            DbUtils.close(connection);
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    void add(TransactionImpl transactionImpl, PrunablePlainMessageAppendix prunablePlainMessageAppendix) {
        this.add(transactionImpl, prunablePlainMessageAppendix, Nxt.getBlockchain().getLastBlockTimestamp(), Nxt.getBlockchain().getHeight());
    }

    void add(TransactionImpl transactionImpl, PrunablePlainMessageAppendix prunablePlainMessageAppendix, int n, int n2) {
        if (prunablePlainMessageAppendix.getMessage() != null) {
            PrunableMessage prunableMessage = (PrunableMessage)this.prunableMessageTable.get(this.prunableMessageKeyFactory.newKey(transactionImpl.getFullHash(), transactionImpl.getId()));
            if (prunableMessage == null) {
                prunableMessage = new PrunableMessage(transactionImpl, n, n2);
            } else if (prunableMessage.height != n2) {
                throw new RuntimeException("Attempt to modify prunable message from height " + prunableMessage.height + " at height " + n2);
            }
            if (prunableMessage.getMessage() == null) {
                prunableMessage.setPlain(prunablePlainMessageAppendix);
                this.prunableMessageTable.insert(prunableMessage);
            }
        }
    }

    public void add(TransactionImpl transactionImpl, PrunableEncryptedMessageAppendix prunableEncryptedMessageAppendix) {
        this.add(transactionImpl, prunableEncryptedMessageAppendix, Nxt.getBlockchain().getLastBlockTimestamp(), Nxt.getBlockchain().getHeight());
    }

    public void add(TransactionImpl transactionImpl, PrunableEncryptedMessageAppendix prunableEncryptedMessageAppendix, int n, int n2) {
        if (prunableEncryptedMessageAppendix.getEncryptedData() != null) {
            PrunableMessage prunableMessage = (PrunableMessage)this.prunableMessageTable.get(this.prunableMessageKeyFactory.newKey(transactionImpl.getFullHash(), transactionImpl.getId()));
            if (prunableMessage == null) {
                prunableMessage = new PrunableMessage(transactionImpl, n, n2);
            } else if (prunableMessage.height != n2) {
                throw new RuntimeException("Attempt to modify prunable message from height " + prunableMessage.height + " at height " + n2);
            }
            if (prunableMessage.getEncryptedData() == null) {
                prunableMessage.setEncrypted(prunableEncryptedMessageAppendix);
                this.prunableMessageTable.insert(prunableMessage);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isPruned(byte[] var1_1, boolean var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final class PrunableMessage {
        private final long id;
        private final byte[] hash;
        private final DbKey dbKey;
        private final long senderId;
        private final long recipientId;
        private byte[] message;
        private EncryptedData encryptedData;
        private boolean messageIsText;
        private boolean encryptedMessageIsText;
        private boolean isCompressed;
        private final int transactionTimestamp;
        private final int blockTimestamp;
        private final int height;

        private PrunableMessage(Transaction transaction, int n, int n2) {
            this.id = transaction.getId();
            this.hash = transaction.getFullHash();
            this.dbKey = PrunableMessageHome.this.prunableMessageKeyFactory.newKey(this.hash, this.id);
            this.senderId = transaction.getSenderId();
            this.recipientId = transaction.getRecipientId();
            this.blockTimestamp = n;
            this.height = n2;
            this.transactionTimestamp = transaction.getTimestamp();
        }

        private void setPlain(PrunablePlainMessageAppendix prunablePlainMessageAppendix) {
            this.message = prunablePlainMessageAppendix.getMessage();
            this.messageIsText = prunablePlainMessageAppendix.isText();
        }

        private void setEncrypted(PrunableEncryptedMessageAppendix prunableEncryptedMessageAppendix) {
            this.encryptedData = prunableEncryptedMessageAppendix.getEncryptedData();
            this.encryptedMessageIsText = prunableEncryptedMessageAppendix.isText();
            this.isCompressed = prunableEncryptedMessageAppendix.isCompressed();
        }

        private PrunableMessage(ResultSet resultSet, DbKey dbKey) throws SQLException {
            byte[] byArray;
            this.id = resultSet.getLong("id");
            this.hash = resultSet.getBytes("full_hash");
            this.dbKey = dbKey;
            this.senderId = resultSet.getLong("sender_id");
            this.recipientId = resultSet.getLong("recipient_id");
            this.message = resultSet.getBytes("message");
            if (this.message != null) {
                this.messageIsText = resultSet.getBoolean("message_is_text");
            }
            if ((byArray = resultSet.getBytes("encrypted_message")) != null) {
                this.encryptedData = EncryptedData.readEncryptedData(byArray);
                this.encryptedMessageIsText = resultSet.getBoolean("encrypted_is_text");
                this.isCompressed = resultSet.getBoolean("is_compressed");
            }
            this.blockTimestamp = resultSet.getInt("block_timestamp");
            this.transactionTimestamp = resultSet.getInt("transaction_timestamp");
            this.height = resultSet.getInt("height");
        }

        private void save(Connection connection) throws SQLException {
            if (this.message == null && this.encryptedData == null) {
                throw new IllegalStateException("Prunable message not fully initialized");
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO prunable_message (id, full_hash, sender_id, recipient_id, message, encrypted_message, message_is_text, encrypted_is_text, is_compressed, block_timestamp, transaction_timestamp, height) KEY (id, full_hash) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setBytes(++n, this.hash);
                preparedStatement.setLong(++n, this.senderId);
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.recipientId);
                DbUtils.setBytes(preparedStatement, ++n, this.message);
                DbUtils.setBytes(preparedStatement, ++n, this.encryptedData == null ? null : this.encryptedData.getBytes());
                preparedStatement.setBoolean(++n, this.messageIsText);
                preparedStatement.setBoolean(++n, this.encryptedMessageIsText);
                preparedStatement.setBoolean(++n, this.isCompressed);
                preparedStatement.setInt(++n, this.blockTimestamp);
                preparedStatement.setInt(++n, this.transactionTimestamp);
                preparedStatement.setInt(++n, this.height);
                preparedStatement.executeUpdate();
            }
        }

        public byte[] getMessage() {
            return this.message;
        }

        public EncryptedData getEncryptedData() {
            return this.encryptedData;
        }

        public boolean messageIsText() {
            return this.messageIsText;
        }

        public boolean encryptedMessageIsText() {
            return this.encryptedMessageIsText;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public long getId() {
            return this.id;
        }

        public byte[] getFullHash() {
            return this.hash;
        }

        public long getSenderId() {
            return this.senderId;
        }

        public long getRecipientId() {
            return this.recipientId;
        }

        public int getTransactionTimestamp() {
            return this.transactionTimestamp;
        }

        public int getBlockTimestamp() {
            return this.blockTimestamp;
        }

        public int getHeight() {
            return this.height;
        }

        public Chain getChain() {
            return PrunableMessageHome.this.chain;
        }

        public byte[] decrypt(String string) {
            if (this.encryptedData == null) {
                return null;
            }
            byte[] byArray = this.senderId == Account.getId(Crypto.getPublicKey(string)) ? Account.getPublicKey(this.recipientId) : Account.getPublicKey(this.senderId);
            return Account.decryptFrom(byArray, this.encryptedData, string, this.isCompressed);
        }

        public byte[] decrypt(byte[] byArray) {
            if (this.encryptedData == null) {
                return null;
            }
            byte[] byArray2 = Crypto.aesDecrypt(this.encryptedData.getData(), byArray);
            if (this.isCompressed) {
                byArray2 = Convert.uncompress(byArray2);
            }
            return byArray2;
        }
    }
}

