/*
 * Decompiled with CFR 0.152.
 */
package nxt.migration;

import java.util.Map;
import nxt.account.HoldingType;
import nxt.blockchain.Block;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Genesis;
import nxt.db.DbIterator;
import nxt.db.TransactionalDb;
import nxt.freeze.FreezeMonitor;
import nxt.migration.HoldingMigration;
import nxt.migration.HoldingSnapshot;
import nxt.util.Listener;
import nxt.util.Logger;

public class HoldingMigrateBlockEventHandler
implements Listener<Block> {
    private final HoldingSnapshot holdingSnapshot;

    public HoldingMigrateBlockEventHandler(HoldingSnapshot holdingSnapshot) {
        this.holdingSnapshot = holdingSnapshot;
    }

    @Override
    public void notify(Block block) {
        try (DbIterator<HoldingMigration> dbIterator = HoldingMigration.getMigrations(block.getHeight());){
            for (HoldingMigration holdingMigration : dbIterator) {
                TransactionalDb.runInDbTransaction(() -> this.handle(holdingMigration));
            }
        }
    }

    private void handle(HoldingMigration holdingMigration) {
        HoldingType holdingType = holdingMigration.getHoldingType();
        long l = holdingMigration.getHoldingId();
        if (holdingType != this.holdingSnapshot.getHoldingType()) {
            return;
        }
        if (holdingType != HoldingType.COIN && !FreezeMonitor.isFrozen(holdingType, l)) {
            Logger.logErrorMessage(String.format("%s %s is not frozen, will not migrate to a child chain!!!", holdingType.name(), Long.toUnsignedString(l)));
            return;
        }
        Map<String, Long> map = this.holdingSnapshot.getSnapshot(holdingMigration);
        ChildChain childChain = holdingMigration.getChildChain();
        Genesis.loadBalances(childChain, map);
    }
}

