/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import nxt.crypto.HashFunction;
import nxt.ms.Currency;
import nxt.ms.CurrencyMintingAttachment;

public final class CurrencyMinting {
    public static final Set<HashFunction> acceptedHashFunctions = Collections.unmodifiableSet(EnumSet.of(HashFunction.SHA256, HashFunction.SHA3, HashFunction.SCRYPT, HashFunction.Keccak25));

    public static boolean meetsTarget(long l, Currency currency, CurrencyMintingAttachment currencyMintingAttachment) {
        byte[] byArray = CurrencyMinting.getHash(currency.getAlgorithm(), currencyMintingAttachment.getNonce(), currencyMintingAttachment.getCurrencyId(), currencyMintingAttachment.getUnitsQNT(), currencyMintingAttachment.getCounter(), l);
        byte[] byArray2 = CurrencyMinting.getTarget(currency.getMinDifficulty(), currency.getMaxDifficulty(), currencyMintingAttachment.getUnitsQNT(), currency.getCurrentSupplyQNT() - currency.getReserveSupplyQNT(), currency.getMaxSupplyQNT() - currency.getReserveSupplyQNT());
        return CurrencyMinting.meetsTarget(byArray, byArray2);
    }

    public static boolean meetsTarget(byte[] byArray, byte[] byArray2) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            if ((byArray[i] & 0xFF) > (byArray2[i] & 0xFF)) {
                return false;
            }
            if ((byArray[i] & 0xFF) >= (byArray2[i] & 0xFF)) continue;
            return true;
        }
        return true;
    }

    public static byte[] getHash(byte by, long l, long l2, long l3, long l4, long l5) {
        HashFunction hashFunction = HashFunction.getHashFunction(by);
        return CurrencyMinting.getHash(hashFunction, l, l2, l3, l4, l5);
    }

    public static byte[] getHash(HashFunction hashFunction, long l, long l2, long l3, long l4, long l5) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(40);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(l);
        byteBuffer.putLong(l2);
        byteBuffer.putLong(l3);
        byteBuffer.putLong(l4);
        byteBuffer.putLong(l5);
        return hashFunction.hash(byteBuffer.array());
    }

    public static byte[] getTarget(int n, int n2, long l, long l2, long l3) {
        return CurrencyMinting.getTarget(CurrencyMinting.getNumericTarget(n, n2, l, l2, l3));
    }

    public static byte[] getTarget(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 32) {
            return CurrencyMinting.reverse(byArray);
        }
        byte[] byArray2 = new byte[32];
        Arrays.fill(byArray2, 0, 32 - byArray.length, (byte)0);
        System.arraycopy(byArray, 0, byArray2, 32 - byArray.length, byArray.length);
        return CurrencyMinting.reverse(byArray2);
    }

    public static BigInteger getNumericTarget(Currency currency, long l) {
        return CurrencyMinting.getNumericTarget(currency.getMinDifficulty(), currency.getMaxDifficulty(), l, currency.getCurrentSupplyQNT() - currency.getReserveSupplyQNT(), currency.getMaxSupplyQNT() - currency.getReserveSupplyQNT());
    }

    public static BigInteger getNumericTarget(int n, int n2, long l, long l2, long l3) {
        if (n < 1 || n2 > 255) {
            throw new IllegalArgumentException(String.format("Min: %d, Max: %d, allowed range is 1 to 255", n, n2));
        }
        int n3 = (int)((long)(256 - n) - (long)(n2 - n) * l2 / l3);
        return BigInteger.valueOf(2L).pow(n3).subtract(BigInteger.ONE).divide(BigInteger.valueOf(l));
    }

    private static byte[] reverse(byte[] byArray) {
        for (int i = 0; i < byArray.length / 2; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[byArray.length - i - 1];
            byArray[byArray.length - i - 1] = by;
        }
        return byArray;
    }

    private CurrencyMinting() {
    }
}

