/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import nxt.NxtException;
import nxt.ae.AssetExchangeTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.Transaction;
import nxt.crypto.HashFunction;
import nxt.ms.Currency;
import nxt.ms.CurrencyIssuanceAttachment;
import nxt.ms.CurrencyMinting;
import nxt.ms.MonetarySystemTransactionType;
import nxt.ms.ReserveIncreaseAttachment;
import nxt.shuffling.ShufflingTransactionType;

public enum CurrencyType {
    EXCHANGEABLE(1){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) {
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystemTransactionType.CURRENCY_ISSUANCE && !set.contains((Object)CLAIMABLE)) {
                throw new NxtException.NotValidException("Currency is not exchangeable and not claimable");
            }
            if (transaction.getType() instanceof MonetarySystemTransactionType.MonetarySystemExchange || transaction.getType() == MonetarySystemTransactionType.PUBLISH_EXCHANGE_OFFER) {
                throw new NxtException.NotValidException("Currency is not exchangeable");
            }
        }
    }
    ,
    CONTROLLABLE(2){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystemTransactionType.CURRENCY_TRANSFER && (currency == null || currency.getAccountId() != transaction.getSenderId() && currency.getAccountId() != transaction.getRecipientId())) {
                throw new NxtException.NotValidException("Controllable currency can only be transferred to/from issuer account");
            }
            if (transaction.getType() == MonetarySystemTransactionType.PUBLISH_EXCHANGE_OFFER && (currency == null || currency.getAccountId() != transaction.getSenderId())) {
                throw new NxtException.NotValidException("Only currency issuer can publish an exchange offer for controllable currency");
            }
            if (transaction.getType() == AssetExchangeTransactionType.DIVIDEND_PAYMENT && (currency == null || currency.getAccountId() != transaction.getSenderId())) {
                throw new NxtException.NotValidException("Only currency issuer can pay dividends in controllable currency");
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) {
        }
    }
    ,
    RESERVABLE(4){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.ValidationException {
            Attachment.AbstractAttachment abstractAttachment;
            if (transaction.getType() == MonetarySystemTransactionType.CURRENCY_ISSUANCE) {
                int n;
                abstractAttachment = (CurrencyIssuanceAttachment)transaction.getAttachment();
                int n2 = ((CurrencyIssuanceAttachment)abstractAttachment).getIssuanceHeight();
                if (n2 <= (n = abstractAttachment.getFinishValidationHeight(transaction))) {
                    throw new NxtException.NotCurrentlyValidException(String.format("Reservable currency activation height %d not higher than transaction apply height %d", n2, n));
                }
                if (((CurrencyIssuanceAttachment)abstractAttachment).getMinReservePerUnitNQT() <= 0L) {
                    throw new NxtException.NotValidException("Minimum reserve per unit must be > 0");
                }
                if (Math.multiplyExact(((CurrencyIssuanceAttachment)abstractAttachment).getMinReservePerUnitNQT(), ((CurrencyIssuanceAttachment)abstractAttachment).getReserveSupplyQNT()) > 100000000000000000L) {
                    throw new NxtException.NotValidException("Minimum reserve per unit is too large");
                }
                if (((CurrencyIssuanceAttachment)abstractAttachment).getReserveSupplyQNT() <= ((CurrencyIssuanceAttachment)abstractAttachment).getInitialSupplyQNT()) {
                    throw new NxtException.NotValidException("Reserve supply must exceed initial supply");
                }
                if (!set.contains((Object)MINTABLE) && ((CurrencyIssuanceAttachment)abstractAttachment).getReserveSupplyQNT() < ((CurrencyIssuanceAttachment)abstractAttachment).getMaxSupplyQNT()) {
                    throw new NxtException.NotValidException("Max supply must not exceed reserve supply for reservable and non-mintable currency");
                }
            }
            if (transaction.getType() == MonetarySystemTransactionType.RESERVE_INCREASE) {
                abstractAttachment = (ReserveIncreaseAttachment)transaction.getAttachment();
                if (currency.getIssuanceHeight() <= abstractAttachment.getFinishValidationHeight(transaction)) {
                    throw new NxtException.NotCurrentlyValidException("Cannot increase reserve for active currency");
                }
                if (currency.getChildChain() != transaction.getChain()) {
                    throw new NxtException.NotValidException("Reserve increase must be submitted on the chain on which the currency was issued");
                }
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystemTransactionType.RESERVE_INCREASE) {
                throw new NxtException.NotValidException("Cannot increase reserve since currency is not reservable");
            }
            if (transaction.getType() == MonetarySystemTransactionType.CURRENCY_ISSUANCE) {
                CurrencyIssuanceAttachment currencyIssuanceAttachment = (CurrencyIssuanceAttachment)transaction.getAttachment();
                if (currencyIssuanceAttachment.getIssuanceHeight() != 0) {
                    throw new NxtException.NotValidException("Issuance height for non-reservable currency must be 0");
                }
                if (currencyIssuanceAttachment.getMinReservePerUnitNQT() > 0L) {
                    throw new NxtException.NotValidException("Minimum reserve per unit for non-reservable currency must be 0 ");
                }
                if (currencyIssuanceAttachment.getReserveSupplyQNT() > 0L) {
                    throw new NxtException.NotValidException("Reserve supply for non-reservable currency must be 0");
                }
                if (!set.contains((Object)MINTABLE) && currencyIssuanceAttachment.getInitialSupplyQNT() < currencyIssuanceAttachment.getMaxSupplyQNT()) {
                    throw new NxtException.NotValidException("Initial supply for non-reservable and non-mintable currency must be equal to max supply");
                }
            }
        }
    }
    ,
    CLAIMABLE(8){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.ValidationException {
            if (transaction.getType() == MonetarySystemTransactionType.CURRENCY_ISSUANCE) {
                CurrencyIssuanceAttachment currencyIssuanceAttachment = (CurrencyIssuanceAttachment)transaction.getAttachment();
                if (!set.contains((Object)RESERVABLE)) {
                    throw new NxtException.NotValidException("Claimable currency must be reservable");
                }
                if (set.contains((Object)MINTABLE)) {
                    throw new NxtException.NotValidException("Claimable currency cannot be mintable");
                }
                if (currencyIssuanceAttachment.getInitialSupplyQNT() > 0L) {
                    throw new NxtException.NotValidException("Claimable currency must have initial supply 0");
                }
            }
            if (transaction.getType() == MonetarySystemTransactionType.RESERVE_CLAIM) {
                if (currency == null || !currency.isActive()) {
                    throw new NxtException.NotCurrentlyValidException("Cannot claim reserve since currency is not yet active");
                }
                if (currency.getChildChain() != transaction.getChain()) {
                    throw new NxtException.NotValidException("Reserve claim must be submitted on the chain on which the currency was issued");
                }
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystemTransactionType.RESERVE_CLAIM) {
                throw new NxtException.NotValidException("Cannot claim reserve since currency is not claimable");
            }
        }
    }
    ,
    MINTABLE(16){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            if (transaction.getType() == MonetarySystemTransactionType.CURRENCY_ISSUANCE) {
                CurrencyIssuanceAttachment currencyIssuanceAttachment = (CurrencyIssuanceAttachment)transaction.getAttachment();
                try {
                    HashFunction hashFunction = HashFunction.getHashFunction(currencyIssuanceAttachment.getAlgorithm());
                    if (!CurrencyMinting.acceptedHashFunctions.contains((Object)hashFunction)) {
                        throw new NxtException.NotValidException("Invalid minting algorithm " + (Object)((Object)hashFunction));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new NxtException.NotValidException("Illegal algorithm code specified", illegalArgumentException);
                }
                if (currencyIssuanceAttachment.getMinDifficulty() < 1 || currencyIssuanceAttachment.getMaxDifficulty() > 255 || currencyIssuanceAttachment.getMaxDifficulty() < currencyIssuanceAttachment.getMinDifficulty()) {
                    throw new NxtException.NotValidException(String.format("Invalid minting difficulties min %d max %d, difficulty must be between 1 and 255, max larger than min", currencyIssuanceAttachment.getMinDifficulty(), currencyIssuanceAttachment.getMaxDifficulty()));
                }
                if (currencyIssuanceAttachment.getMaxSupplyQNT() <= currencyIssuanceAttachment.getReserveSupplyQNT()) {
                    throw new NxtException.NotValidException("Max supply for mintable currency must exceed reserve supply");
                }
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.NotValidException {
            CurrencyIssuanceAttachment currencyIssuanceAttachment;
            if (transaction.getType() == MonetarySystemTransactionType.CURRENCY_ISSUANCE && ((currencyIssuanceAttachment = (CurrencyIssuanceAttachment)transaction.getAttachment()).getMinDifficulty() != 0 || currencyIssuanceAttachment.getMaxDifficulty() != 0 || currencyIssuanceAttachment.getAlgorithm() != 0)) {
                throw new NxtException.NotValidException("Non mintable currency should not specify algorithm or difficulty");
            }
            if (transaction.getType() == MonetarySystemTransactionType.CURRENCY_MINTING) {
                throw new NxtException.NotValidException("Currency is not mintable");
            }
        }
    }
    ,
    NON_SHUFFLEABLE(32){

        @Override
        void validate(Currency currency, Transaction transaction, Set<CurrencyType> set) throws NxtException.ValidationException {
            if (transaction.getType() == ShufflingTransactionType.SHUFFLING_CREATION) {
                throw new NxtException.NotValidException("Shuffling is not allowed for this currency");
            }
        }

        @Override
        void validateMissing(Currency currency, Transaction transaction, Set<CurrencyType> set) {
        }
    };

    private final int code;

    private CurrencyType(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    abstract void validate(Currency var1, Transaction var2, Set<CurrencyType> var3) throws NxtException.ValidationException;

    abstract void validateMissing(Currency var1, Transaction var2, Set<CurrencyType> var3) throws NxtException.ValidationException;

    public static CurrencyType get(int n) {
        for (CurrencyType currencyType : CurrencyType.values()) {
            if (currencyType.getCode() != n) continue;
            return currencyType;
        }
        return null;
    }

    public static void validate(Currency currency, Transaction transaction) throws NxtException.ValidationException {
        if (currency == null) {
            throw new NxtException.NotCurrentlyValidException("Unknown currency: " + transaction.getAttachment().getJSONObject());
        }
        CurrencyType.validate(currency, currency.getType(), transaction);
    }

    static void validate(int n, Transaction transaction) throws NxtException.ValidationException {
        CurrencyType.validate(null, n, transaction);
    }

    private static void validate(Currency currency, int n, Transaction transaction) throws NxtException.ValidationException {
        if (transaction.getAmount() != 0L) {
            throw new NxtException.NotValidException("Currency transaction coin amount must be 0");
        }
        EnumSet<CurrencyType> enumSet = EnumSet.noneOf(CurrencyType.class);
        for (CurrencyType currencyType : CurrencyType.values()) {
            if ((currencyType.getCode() & n) == 0) continue;
            enumSet.add(currencyType);
        }
        if (enumSet.isEmpty()) {
            throw new NxtException.NotValidException("Currency type not specified");
        }
        for (CurrencyType currencyType : CurrencyType.values()) {
            if ((currencyType.getCode() & n) != 0) {
                currencyType.validate(currency, transaction, enumSet);
                continue;
            }
            currencyType.validateMissing(currency, transaction, enumSet);
        }
    }

    static void validateCurrencyNaming(ChildTransaction childTransaction, CurrencyIssuanceAttachment currencyIssuanceAttachment) throws NxtException.ValidationException {
        int n;
        long l = childTransaction.getSenderId();
        ChildChain childChain = childTransaction.getChain();
        String string = currencyIssuanceAttachment.getName();
        String string2 = currencyIssuanceAttachment.getCode();
        String string3 = currencyIssuanceAttachment.getDescription();
        if (!(string.length() >= 3 && CurrencyIssuanceAttachment.NAME_RW.validate(string) && string.length() >= string2.length() && string2.length() >= 3 && CurrencyIssuanceAttachment.CODE_RW.validate(string2) && CurrencyIssuanceAttachment.DESCRIPTION_RW.validate(string3))) {
            throw new NxtException.NotValidException(String.format("Invalid currency name %s code %s or description %s", string, string2, string3));
        }
        String string4 = string.toLowerCase(Locale.ROOT);
        for (n = 0; n < string4.length(); ++n) {
            if ("0123456789abcdefghijklmnopqrstuvwxyz".indexOf(string4.charAt(n)) >= 0) continue;
            throw new NxtException.NotValidException("Invalid currency name: " + string4);
        }
        for (n = 0; n < string2.length(); ++n) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(string2.charAt(n)) >= 0) continue;
            throw new NxtException.NotValidException("Invalid currency code: " + string2 + " code must be all upper case");
        }
        if (string2.equals("ARDOR") || string2.contains("ARDR") || "ardor".equals(string4) || "ardr".equals(string4)) {
            throw new NxtException.NotValidException("Currency name already used");
        }
        if (string2.equals(childChain.getName().toUpperCase(Locale.ROOT)) || childChain.getName().toLowerCase(Locale.ROOT).equals(string4)) {
            throw new NxtException.NotValidException("Currency name already used");
        }
        if (string2.contains("NXT") || string2.contains("NEXT") || "nxt".equals(string4) || "next".equals(string4)) {
            throw new NxtException.NotValidException("Currency name already used");
        }
        if (string2.equals("IGNIS") || "ignis".equals(string4)) {
            throw new NxtException.NotValidException("Currency name already used");
        }
        Currency currency = Currency.getCurrencyByName(childChain, string4);
        if (currency != null && !currency.canBeDeletedBy(l)) {
            throw new NxtException.NotCurrentlyValidException("Currency name already used: " + string4);
        }
        currency = Currency.getCurrencyByCode(childChain, string);
        if (currency != null && !currency.canBeDeletedBy(l)) {
            throw new NxtException.NotCurrentlyValidException("Currency name already used as code: " + string4);
        }
        currency = Currency.getCurrencyByCode(childChain, string2);
        if (currency != null && !currency.canBeDeletedBy(l)) {
            throw new NxtException.NotCurrentlyValidException("Currency code already used: " + string2);
        }
        currency = Currency.getCurrencyByName(childChain, string2);
        if (currency != null && !currency.canBeDeletedBy(l)) {
            throw new NxtException.NotCurrentlyValidException("Currency code already used as name: " + string2);
        }
    }
}

