/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.BalanceHome;
import nxt.blockchain.Attachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.ms.Currency;
import nxt.ms.CurrencyDeletionAttachment;
import nxt.ms.CurrencyFreezeMonitor;
import nxt.ms.CurrencyIssuanceAttachment;
import nxt.ms.CurrencyMint;
import nxt.ms.CurrencyMinting;
import nxt.ms.CurrencyMintingAttachment;
import nxt.ms.CurrencyTransfer;
import nxt.ms.CurrencyTransferAttachment;
import nxt.ms.CurrencyType;
import nxt.ms.ExchangeAttachment;
import nxt.ms.ExchangeBuyAttachment;
import nxt.ms.ExchangeSellAttachment;
import nxt.ms.MonetarySystemAttachment;
import nxt.ms.PublishExchangeOfferAttachment;
import nxt.ms.ReserveClaimAttachment;
import nxt.ms.ReserveIncreaseAttachment;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public abstract class MonetarySystemTransactionType<Att extends Attachment.AbstractAttachment>
extends ChildTransactionType {
    private static final byte SUBTYPE_MONETARY_SYSTEM_CURRENCY_ISSUANCE = 0;
    private static final byte SUBTYPE_MONETARY_SYSTEM_RESERVE_INCREASE = 1;
    private static final byte SUBTYPE_MONETARY_SYSTEM_RESERVE_CLAIM = 2;
    private static final byte SUBTYPE_MONETARY_SYSTEM_CURRENCY_TRANSFER = 3;
    private static final byte SUBTYPE_MONETARY_SYSTEM_PUBLISH_EXCHANGE_OFFER = 4;
    private static final byte SUBTYPE_MONETARY_SYSTEM_EXCHANGE_BUY = 5;
    private static final byte SUBTYPE_MONETARY_SYSTEM_EXCHANGE_SELL = 6;
    private static final byte SUBTYPE_MONETARY_SYSTEM_CURRENCY_MINTING = 7;
    private static final byte SUBTYPE_MONETARY_SYSTEM_CURRENCY_DELETION = 8;
    public static final TransactionType CURRENCY_ISSUANCE = new MonetarySystemTransactionType<CurrencyIssuanceAttachment>(){
        private final Fee FIVE_LETTER_CURRENCY_ISSUANCE_FEE = new Fee.ConstantFee(400000000L);
        private final Fee FOUR_LETTER_CURRENCY_ISSUANCE_FEE = new Fee.ConstantFee(10000000000L);
        private final Fee THREE_LETTER_CURRENCY_ISSUANCE_FEE = new Fee.ConstantFee(250000000000L);

        @Override
        public byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_ISSUANCE;
        }

        @Override
        public String getName() {
            return "CurrencyIssuance";
        }

        @Override
        protected void checkLiquid(ChildTransactionImpl childTransactionImpl) {
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            ChildChain childChain = (ChildChain)transaction.getChain();
            CurrencyIssuanceAttachment currencyIssuanceAttachment = (CurrencyIssuanceAttachment)transaction.getAttachment();
            int n = Math.min(currencyIssuanceAttachment.getCode().length(), currencyIssuanceAttachment.getName().length());
            int n2 = Integer.MAX_VALUE;
            Currency currency = Currency.getCurrencyByCode(childChain, currencyIssuanceAttachment.getCode());
            if (currency != null) {
                n2 = Math.min(n2, Math.min(currency.getCode().length(), currency.getName().length()));
            }
            if ((currency = Currency.getCurrencyByCode(childChain, currencyIssuanceAttachment.getName())) != null) {
                n2 = Math.min(n2, Math.min(currency.getCode().length(), currency.getName().length()));
            }
            if ((currency = Currency.getCurrencyByName(childChain, currencyIssuanceAttachment.getName())) != null) {
                n2 = Math.min(n2, Math.min(currency.getCode().length(), currency.getName().length()));
            }
            if ((currency = Currency.getCurrencyByName(childChain, currencyIssuanceAttachment.getCode())) != null) {
                n2 = Math.min(n2, Math.min(currency.getCode().length(), currency.getName().length()));
            }
            if (n >= n2) {
                return this.FIVE_LETTER_CURRENCY_ISSUANCE_FEE;
            }
            switch (n) {
                case 3: {
                    return this.THREE_LETTER_CURRENCY_ISSUANCE_FEE;
                }
                case 4: {
                    return this.FOUR_LETTER_CURRENCY_ISSUANCE_FEE;
                }
                case 5: {
                    return this.FIVE_LETTER_CURRENCY_ISSUANCE_FEE;
                }
            }
            return this.THREE_LETTER_CURRENCY_ISSUANCE_FEE;
        }

        @Override
        public CurrencyIssuanceAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new CurrencyIssuanceAttachment(byteBuffer);
        }

        @Override
        public CurrencyIssuanceAttachment parseAttachment(JSONObject jSONObject) {
            return new CurrencyIssuanceAttachment(jSONObject);
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            CurrencyIssuanceAttachment currencyIssuanceAttachment = (CurrencyIssuanceAttachment)transaction.getAttachment();
            String string = currencyIssuanceAttachment.getName().toLowerCase(Locale.ROOT);
            String string2 = currencyIssuanceAttachment.getCode().toLowerCase(Locale.ROOT);
            boolean bl = TransactionType.isDuplicate(CURRENCY_ISSUANCE, string, map, true);
            if (!string.equals(string2)) {
                bl = bl || TransactionType.isDuplicate(CURRENCY_ISSUANCE, string2, map, true);
            }
            return bl;
        }

        @Override
        public boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            return 1.isDuplicate(CURRENCY_ISSUANCE, this.getName(), map, true);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, CurrencyIssuanceAttachment currencyIssuanceAttachment) throws NxtException.ValidationException {
            if (currencyIssuanceAttachment.getMaxSupplyQNT() > 100000000000000000L || currencyIssuanceAttachment.getMaxSupplyQNT() <= 0L || currencyIssuanceAttachment.getInitialSupplyQNT() < 0L || currencyIssuanceAttachment.getInitialSupplyQNT() > currencyIssuanceAttachment.getMaxSupplyQNT() || currencyIssuanceAttachment.getReserveSupplyQNT() < 0L || currencyIssuanceAttachment.getReserveSupplyQNT() > currencyIssuanceAttachment.getMaxSupplyQNT() || currencyIssuanceAttachment.getIssuanceHeight() < 0 || currencyIssuanceAttachment.getMinReservePerUnitNQT() < 0L || currencyIssuanceAttachment.getDecimals() < 0 || currencyIssuanceAttachment.getDecimals() > 8 || currencyIssuanceAttachment.getRuleset() != 0) {
                throw new NxtException.NotValidException("Invalid currency issuance: " + currencyIssuanceAttachment.getJSONObject());
            }
            int n = 1;
            for (int i = 0; i < 32; ++i) {
                if ((n & currencyIssuanceAttachment.getType()) != 0 && CurrencyType.get(n) == null) {
                    throw new NxtException.NotValidException("Invalid currency type: " + currencyIssuanceAttachment.getType());
                }
                n <<= 1;
            }
            CurrencyType.validate(currencyIssuanceAttachment.getType(), (Transaction)childTransactionImpl);
            CurrencyType.validateCurrencyNaming(childTransactionImpl, currencyIssuanceAttachment);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            CurrencyIssuanceAttachment currencyIssuanceAttachment = (CurrencyIssuanceAttachment)childTransactionImpl.getAttachment();
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(childTransactionImpl);
            Currency.addCurrency(this.getLedgerEvent(), ledgerEventId, childTransactionImpl, account, currencyIssuanceAttachment);
            account.addToCurrencyAndUnconfirmedCurrencyUnits(this.getLedgerEvent(), ledgerEventId, childTransactionImpl.getId(), currencyIssuanceAttachment.getInitialSupplyQNT());
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (Currency.getCurrency(childTransactionImpl.getId(), true) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate currency id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType RESERVE_INCREASE = new MonetarySystemTransactionType<ReserveIncreaseAttachment>(){

        @Override
        public byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_RESERVE_INCREASE;
        }

        @Override
        public String getName() {
            return "ReserveIncrease";
        }

        @Override
        public ReserveIncreaseAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new ReserveIncreaseAttachment(byteBuffer);
        }

        @Override
        public ReserveIncreaseAttachment parseAttachment(JSONObject jSONObject) {
            return new ReserveIncreaseAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, ReserveIncreaseAttachment reserveIncreaseAttachment) throws NxtException.ValidationException {
            if (reserveIncreaseAttachment.getAmountPerUnitNQT() <= 0L) {
                throw new NxtException.NotValidException("Reserve increase coin amount must be positive: " + reserveIncreaseAttachment.getAmountPerUnitNQT());
            }
            Currency currency = Currency.getCurrency(reserveIncreaseAttachment.getCurrencyId());
            CurrencyType.validate(currency, (Transaction)childTransactionImpl);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ReserveIncreaseAttachment reserveIncreaseAttachment = (ReserveIncreaseAttachment)childTransactionImpl.getAttachment();
            Currency currency = Currency.getCurrency(reserveIncreaseAttachment.getCurrencyId());
            ChildChain childChain = childTransactionImpl.getChain();
            long l = Convert.unitRateToAmount(currency.getReserveSupplyQNT(), currency.getDecimals(), reserveIncreaseAttachment.getAmountPerUnitNQT(), childChain.getDecimals());
            BalanceHome.Balance balance = childChain.getBalanceHome().getBalance(account.getId());
            if (balance.getUnconfirmedBalance() < l) {
                return false;
            }
            balance.addToUnconfirmedBalance(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), -l);
            return true;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ReserveIncreaseAttachment reserveIncreaseAttachment = (ReserveIncreaseAttachment)childTransactionImpl.getAttachment();
            Currency currency = Currency.getCurrency(reserveIncreaseAttachment.getCurrencyId(), true);
            if (currency == null) {
                return;
            }
            ChildChain childChain = childTransactionImpl.getChain();
            long l = Convert.unitRateToAmount(currency.getReserveSupplyQNT(), currency.getDecimals(), reserveIncreaseAttachment.getAmountPerUnitNQT(), childChain.getDecimals());
            account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), l);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ReserveIncreaseAttachment reserveIncreaseAttachment = (ReserveIncreaseAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getCurrencyFounderHome().increaseReserve(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), account, reserveIncreaseAttachment.getCurrencyId(), reserveIncreaseAttachment.getAmountPerUnitNQT());
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType RESERVE_CLAIM = new MonetarySystemTransactionType<ReserveClaimAttachment>(){

        @Override
        public byte getSubtype() {
            return 2;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_RESERVE_CLAIM;
        }

        @Override
        public String getName() {
            return "ReserveClaim";
        }

        @Override
        public ReserveClaimAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new ReserveClaimAttachment(byteBuffer);
        }

        @Override
        public ReserveClaimAttachment parseAttachment(JSONObject jSONObject) {
            return new ReserveClaimAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, ReserveClaimAttachment reserveClaimAttachment) throws NxtException.ValidationException {
            if (reserveClaimAttachment.getUnitsQNT() <= 0L) {
                throw new NxtException.NotValidException("Reserve claim number of units must be positive: " + reserveClaimAttachment.getUnitsQNT());
            }
            Currency currency = Currency.getCurrency(reserveClaimAttachment.getCurrencyId());
            CurrencyType.validate(currency, (Transaction)childTransactionImpl);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ReserveClaimAttachment reserveClaimAttachment = (ReserveClaimAttachment)childTransactionImpl.getAttachment();
            if (account.getUnconfirmedCurrencyUnits(reserveClaimAttachment.getCurrencyId()) >= reserveClaimAttachment.getUnitsQNT()) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), reserveClaimAttachment.getCurrencyId(), -reserveClaimAttachment.getUnitsQNT());
                return true;
            }
            return false;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ReserveClaimAttachment reserveClaimAttachment = (ReserveClaimAttachment)childTransactionImpl.getAttachment();
            Currency currency = Currency.getCurrency(reserveClaimAttachment.getCurrencyId());
            if (currency != null) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), reserveClaimAttachment.getCurrencyId(), reserveClaimAttachment.getUnitsQNT());
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ReserveClaimAttachment reserveClaimAttachment = (ReserveClaimAttachment)childTransactionImpl.getAttachment();
            Currency.claimReserve(childTransactionImpl.getChain(), this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), account, reserveClaimAttachment.getCurrencyId(), reserveClaimAttachment.getUnitsQNT());
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType CURRENCY_TRANSFER = new MonetarySystemTransactionType<CurrencyTransferAttachment>(){

        @Override
        public byte getSubtype() {
            return 3;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_TRANSFER;
        }

        @Override
        public String getName() {
            return "CurrencyTransfer";
        }

        @Override
        public CurrencyTransferAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new CurrencyTransferAttachment(byteBuffer);
        }

        @Override
        public CurrencyTransferAttachment parseAttachment(JSONObject jSONObject) {
            return new CurrencyTransferAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, CurrencyTransferAttachment currencyTransferAttachment) throws NxtException.ValidationException {
            if (currencyTransferAttachment.getUnitsQNT() <= 0L) {
                throw new NxtException.NotValidException("Invalid currency transfer: " + currencyTransferAttachment.getJSONObject());
            }
            Currency currency = Currency.getCurrency(currencyTransferAttachment.getCurrencyId());
            CurrencyType.validate(currency, (Transaction)childTransactionImpl);
            if (!currency.isActive()) {
                throw new NxtException.NotCurrentlyValidException("Currency not currently active: " + currencyTransferAttachment.getJSONObject());
            }
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            CurrencyTransferAttachment currencyTransferAttachment = (CurrencyTransferAttachment)childTransactionImpl.getAttachment();
            if (currencyTransferAttachment.getUnitsQNT() > account.getUnconfirmedCurrencyUnits(currencyTransferAttachment.getCurrencyId())) {
                return false;
            }
            account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), currencyTransferAttachment.getCurrencyId(), -currencyTransferAttachment.getUnitsQNT());
            return true;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            CurrencyTransferAttachment currencyTransferAttachment = (CurrencyTransferAttachment)childTransactionImpl.getAttachment();
            Currency currency = Currency.getCurrency(currencyTransferAttachment.getCurrencyId());
            if (currency != null) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), currencyTransferAttachment.getCurrencyId(), currencyTransferAttachment.getUnitsQNT());
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            CurrencyTransferAttachment currencyTransferAttachment = (CurrencyTransferAttachment)childTransactionImpl.getAttachment();
            Currency.transferCurrency(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), account, account2, currencyTransferAttachment.getCurrencyId(), currencyTransferAttachment.getUnitsQNT());
            CurrencyTransfer.addTransfer(childTransactionImpl, currencyTransferAttachment);
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public final boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType PUBLISH_EXCHANGE_OFFER = new MonetarySystemTransactionType<PublishExchangeOfferAttachment>(){

        @Override
        public byte getSubtype() {
            return 4;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_PUBLISH_EXCHANGE_OFFER;
        }

        @Override
        public String getName() {
            return "PublishExchangeOffer";
        }

        @Override
        public PublishExchangeOfferAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new PublishExchangeOfferAttachment(byteBuffer);
        }

        @Override
        public PublishExchangeOfferAttachment parseAttachment(JSONObject jSONObject) {
            return new PublishExchangeOfferAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, PublishExchangeOfferAttachment publishExchangeOfferAttachment) throws NxtException.ValidationException {
            if (publishExchangeOfferAttachment.getBuyRateNQT() <= 0L || publishExchangeOfferAttachment.getSellRateNQT() <= 0L || publishExchangeOfferAttachment.getBuyRateNQT() > publishExchangeOfferAttachment.getSellRateNQT()) {
                throw new NxtException.NotValidException(String.format("Invalid exchange offer, buy rate %d and sell rate %d has to be larger than 0, buy rate cannot be larger than sell rate", publishExchangeOfferAttachment.getBuyRateNQT(), publishExchangeOfferAttachment.getSellRateNQT()));
            }
            if (publishExchangeOfferAttachment.getTotalBuyLimitQNT() < 0L || publishExchangeOfferAttachment.getTotalSellLimitQNT() < 0L || publishExchangeOfferAttachment.getInitialBuySupplyQNT() < 0L || publishExchangeOfferAttachment.getInitialSellSupplyQNT() < 0L || publishExchangeOfferAttachment.getExpirationHeight() < 0) {
                throw new NxtException.NotValidException("Invalid exchange offer, units and height cannot be negative: " + publishExchangeOfferAttachment.getJSONObject());
            }
            if (publishExchangeOfferAttachment.getTotalBuyLimitQNT() < publishExchangeOfferAttachment.getInitialBuySupplyQNT() || publishExchangeOfferAttachment.getTotalSellLimitQNT() < publishExchangeOfferAttachment.getInitialSellSupplyQNT()) {
                throw new NxtException.NotValidException("Initial supplies must not exceed total limits");
            }
            if (publishExchangeOfferAttachment.getTotalBuyLimitQNT() == 0L && publishExchangeOfferAttachment.getTotalSellLimitQNT() == 0L) {
                throw new NxtException.NotValidException("Total buy and sell limits cannot be both 0");
            }
            if (publishExchangeOfferAttachment.getInitialBuySupplyQNT() == 0L && publishExchangeOfferAttachment.getInitialSellSupplyQNT() == 0L) {
                throw new NxtException.NotValidException("Initial buy and sell supply cannot be both 0");
            }
            if (publishExchangeOfferAttachment.getExpirationHeight() <= publishExchangeOfferAttachment.getFinishValidationHeight(childTransactionImpl)) {
                throw new NxtException.NotCurrentlyValidException("Expiration height must be after transaction execution height");
            }
            Currency currency = Currency.getCurrency(publishExchangeOfferAttachment.getCurrencyId());
            CurrencyType.validate(currency, (Transaction)childTransactionImpl);
            if (!currency.isActive()) {
                throw new NxtException.NotCurrentlyValidException("Currency not currently active: " + publishExchangeOfferAttachment.getJSONObject());
            }
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)childTransactionImpl.getAttachment();
            long l = publishExchangeOfferAttachment.getCurrencyId();
            Currency currency = Currency.getCurrency(l);
            ChildChain childChain = childTransactionImpl.getChain();
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(childTransactionImpl);
            if (publishExchangeOfferAttachment.getInitialBuySupplyQNT() > 0L) {
                long l2 = Convert.unitRateToAmount(publishExchangeOfferAttachment.getInitialBuySupplyQNT(), currency.getDecimals(), publishExchangeOfferAttachment.getBuyRateNQT(), childChain.getDecimals());
                BalanceHome.Balance balance = childChain.getBalanceHome().getBalance(account.getId());
                if (balance.getUnconfirmedBalance() < l2) {
                    return false;
                }
                balance.addToUnconfirmedBalance(this.getLedgerEvent(), ledgerEventId, -l2);
            }
            if (account.getUnconfirmedCurrencyUnits(l) < publishExchangeOfferAttachment.getInitialSellSupplyQNT()) {
                return false;
            }
            account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), ledgerEventId, l, -publishExchangeOfferAttachment.getInitialSellSupplyQNT());
            return true;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)childTransactionImpl.getAttachment();
            long l = publishExchangeOfferAttachment.getCurrencyId();
            Currency currency = Currency.getCurrency(l, true);
            if (currency == null) {
                return;
            }
            ChildChain childChain = childTransactionImpl.getChain();
            AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(childTransactionImpl);
            if (publishExchangeOfferAttachment.getInitialBuySupplyQNT() > 0L) {
                long l2 = Convert.unitRateToAmount(publishExchangeOfferAttachment.getInitialBuySupplyQNT(), currency.getDecimals(), publishExchangeOfferAttachment.getBuyRateNQT(), childChain.getDecimals());
                account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), ledgerEventId, l2);
            }
            if (!currency.isDeleted()) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), ledgerEventId, l, publishExchangeOfferAttachment.getInitialSellSupplyQNT());
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            PublishExchangeOfferAttachment publishExchangeOfferAttachment = (PublishExchangeOfferAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getExchangeOfferHome().publishOffer(childTransactionImpl, publishExchangeOfferAttachment);
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (childTransactionImpl.getChain().getExchangeOfferHome().getBuyOffer(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate exchange offer id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return true;
        }
    };
    public static final TransactionType EXCHANGE_BUY = new MonetarySystemExchange(){

        @Override
        public byte getSubtype() {
            return 5;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_EXCHANGE_BUY;
        }

        @Override
        public String getName() {
            return "ExchangeBuy";
        }

        @Override
        public ExchangeBuyAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new ExchangeBuyAttachment(byteBuffer);
        }

        @Override
        public ExchangeBuyAttachment parseAttachment(JSONObject jSONObject) {
            return new ExchangeBuyAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ExchangeBuyAttachment exchangeBuyAttachment = (ExchangeBuyAttachment)childTransactionImpl.getAttachment();
            long l = exchangeBuyAttachment.getCurrencyId();
            Currency currency = Currency.getCurrency(l);
            ChildChain childChain = childTransactionImpl.getChain();
            long l2 = Convert.unitRateToAmount(exchangeBuyAttachment.getUnitsQNT(), currency.getDecimals(), exchangeBuyAttachment.getRateNQT(), childChain.getDecimals());
            BalanceHome.Balance balance = childChain.getBalanceHome().getBalance(account.getId());
            if (balance.getUnconfirmedBalance() < l2) {
                return false;
            }
            balance.addToUnconfirmedBalance(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), -l2);
            return true;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ExchangeBuyAttachment exchangeBuyAttachment = (ExchangeBuyAttachment)childTransactionImpl.getAttachment();
            long l = exchangeBuyAttachment.getCurrencyId();
            Currency currency = Currency.getCurrency(l, true);
            if (currency == null) {
                return;
            }
            ChildChain childChain = childTransactionImpl.getChain();
            long l2 = Convert.unitRateToAmount(exchangeBuyAttachment.getUnitsQNT(), currency.getDecimals(), exchangeBuyAttachment.getRateNQT(), childChain.getDecimals());
            account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), l2);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ExchangeBuyAttachment exchangeBuyAttachment = (ExchangeBuyAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getExchangeRequestHome().addExchangeRequest((Transaction)childTransactionImpl, exchangeBuyAttachment);
            childTransactionImpl.getChain().getExchangeOfferHome().exchangeNXTForCurrency(childTransactionImpl, account, exchangeBuyAttachment.getCurrencyId(), exchangeBuyAttachment.getRateNQT(), exchangeBuyAttachment.getUnitsQNT());
        }
    };
    public static final TransactionType EXCHANGE_SELL = new MonetarySystemExchange(){

        @Override
        public byte getSubtype() {
            return 6;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_EXCHANGE_SELL;
        }

        @Override
        public String getName() {
            return "ExchangeSell";
        }

        @Override
        public ExchangeSellAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new ExchangeSellAttachment(byteBuffer);
        }

        @Override
        public ExchangeSellAttachment parseAttachment(JSONObject jSONObject) {
            return new ExchangeSellAttachment(jSONObject);
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ExchangeSellAttachment exchangeSellAttachment = (ExchangeSellAttachment)childTransactionImpl.getAttachment();
            if (account.getUnconfirmedCurrencyUnits(exchangeSellAttachment.getCurrencyId()) >= exchangeSellAttachment.getUnitsQNT()) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), exchangeSellAttachment.getCurrencyId(), -exchangeSellAttachment.getUnitsQNT());
                return true;
            }
            return false;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            ExchangeSellAttachment exchangeSellAttachment = (ExchangeSellAttachment)childTransactionImpl.getAttachment();
            Currency currency = Currency.getCurrency(exchangeSellAttachment.getCurrencyId());
            if (currency != null) {
                account.addToUnconfirmedCurrencyUnits(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), exchangeSellAttachment.getCurrencyId(), exchangeSellAttachment.getUnitsQNT());
            }
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            ExchangeSellAttachment exchangeSellAttachment = (ExchangeSellAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getExchangeRequestHome().addExchangeRequest((Transaction)childTransactionImpl, exchangeSellAttachment);
            childTransactionImpl.getChain().getExchangeOfferHome().exchangeCurrencyForNXT(childTransactionImpl, account, exchangeSellAttachment.getCurrencyId(), exchangeSellAttachment.getRateNQT(), exchangeSellAttachment.getUnitsQNT());
        }
    };
    public static final TransactionType CURRENCY_MINTING = new MonetarySystemTransactionType<CurrencyMintingAttachment>(){

        @Override
        public byte getSubtype() {
            return 7;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_MINTING;
        }

        @Override
        public String getName() {
            return "CurrencyMinting";
        }

        @Override
        public CurrencyMintingAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new CurrencyMintingAttachment(byteBuffer);
        }

        @Override
        public CurrencyMintingAttachment parseAttachment(JSONObject jSONObject) {
            return new CurrencyMintingAttachment(jSONObject);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, CurrencyMintingAttachment currencyMintingAttachment) throws NxtException.ValidationException {
            Currency currency = Currency.getCurrency(currencyMintingAttachment.getCurrencyId());
            CurrencyType.validate(currency, (Transaction)childTransactionImpl);
            if (currencyMintingAttachment.getUnitsQNT() <= 0L) {
                throw new NxtException.NotValidException("Invalid number of units: " + currencyMintingAttachment.getUnitsQNT());
            }
            if (currencyMintingAttachment.getUnitsQNT() > (currency.getMaxSupplyQNT() - currency.getReserveSupplyQNT()) / 10000L) {
                throw new NxtException.NotValidException(String.format("Cannot mint more than 1/%d of the total units supply in a single request", 10000));
            }
            if (!currency.isActive()) {
                throw new NxtException.NotCurrentlyValidException("Currency not currently active " + currencyMintingAttachment.getJSONObject());
            }
            long l = CurrencyMint.getCounter(currencyMintingAttachment.getCurrencyId(), childTransactionImpl.getSenderId());
            if (currencyMintingAttachment.getCounter() <= l) {
                throw new NxtException.NotCurrentlyValidException(String.format("Counter %d has to be bigger than %d", currencyMintingAttachment.getCounter(), l));
            }
            if (!CurrencyMinting.meetsTarget(childTransactionImpl.getSenderId(), currency, currencyMintingAttachment)) {
                throw new NxtException.NotCurrentlyValidException(String.format("Hash doesn't meet target %s", currencyMintingAttachment.getJSONObject()));
            }
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            CurrencyMintingAttachment currencyMintingAttachment = (CurrencyMintingAttachment)childTransactionImpl.getAttachment();
            CurrencyMint.mintCurrency(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), account, currencyMintingAttachment);
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            CurrencyMintingAttachment currencyMintingAttachment = (CurrencyMintingAttachment)transaction.getAttachment();
            return TransactionType.isDuplicate(CURRENCY_MINTING, currencyMintingAttachment.getCurrencyId() + ":" + transaction.getSenderId(), map, true) || super.isDuplicate(transaction, map);
        }

        @Override
        public boolean isUnconfirmedDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            CurrencyMintingAttachment currencyMintingAttachment = (CurrencyMintingAttachment)transaction.getAttachment();
            return TransactionType.isDuplicate(CURRENCY_MINTING, currencyMintingAttachment.getCurrencyId() + ":" + transaction.getSenderId(), map, true);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType CURRENCY_DELETION = new MonetarySystemTransactionType<CurrencyDeletionAttachment>(){

        @Override
        public byte getSubtype() {
            return 8;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.CURRENCY_DELETION;
        }

        @Override
        public String getName() {
            return "CurrencyDeletion";
        }

        @Override
        public CurrencyDeletionAttachment parseAttachment(ByteBuffer byteBuffer) {
            return new CurrencyDeletionAttachment(byteBuffer);
        }

        @Override
        public CurrencyDeletionAttachment parseAttachment(JSONObject jSONObject) {
            return new CurrencyDeletionAttachment(jSONObject);
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            CurrencyDeletionAttachment currencyDeletionAttachment = (CurrencyDeletionAttachment)transaction.getAttachment();
            Currency currency = Currency.getCurrency(currencyDeletionAttachment.getCurrencyId());
            String string = currency.getName().toLowerCase(Locale.ROOT);
            String string2 = currency.getCode().toLowerCase(Locale.ROOT);
            boolean bl = TransactionType.isDuplicate(CURRENCY_ISSUANCE, string, map, true);
            if (!string.equals(string2)) {
                bl = bl || TransactionType.isDuplicate(CURRENCY_ISSUANCE, string2, map, true);
            }
            return bl;
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl, CurrencyDeletionAttachment currencyDeletionAttachment) throws NxtException.ValidationException {
            Currency currency = Currency.getCurrency(currencyDeletionAttachment.getCurrencyId());
            CurrencyType.validate(currency, (Transaction)childTransactionImpl);
            if (!currency.canBeDeletedBy(childTransactionImpl.getSenderId())) {
                throw new NxtException.NotCurrentlyValidException("Currency " + Long.toUnsignedString(currency.getId()) + " cannot be deleted by account " + Long.toUnsignedString(childTransactionImpl.getSenderId()));
            }
        }

        @Override
        public boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
            return true;
        }

        @Override
        public void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            CurrencyDeletionAttachment currencyDeletionAttachment = (CurrencyDeletionAttachment)childTransactionImpl.getAttachment();
            Currency currency = Currency.getCurrency(currencyDeletionAttachment.getCurrencyId());
            currency.delete(this.getLedgerEvent(), AccountLedger.newEventId(childTransactionImpl), account);
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return false;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return CURRENCY_ISSUANCE;
            }
            case 1: {
                return RESERVE_INCREASE;
            }
            case 2: {
                return RESERVE_CLAIM;
            }
            case 3: {
                return CURRENCY_TRANSFER;
            }
            case 4: {
                return PUBLISH_EXCHANGE_OFFER;
            }
            case 5: {
                return EXCHANGE_BUY;
            }
            case 6: {
                return EXCHANGE_SELL;
            }
            case 7: {
                return CURRENCY_MINTING;
            }
            case 8: {
                return CURRENCY_DELETION;
            }
        }
        return null;
    }

    private MonetarySystemTransactionType() {
    }

    @Override
    public final void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
        this.checkLiquid(childTransactionImpl);
        this.validateAttachment(childTransactionImpl, childTransactionImpl.getAttachment());
    }

    protected void checkLiquid(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
        MonetarySystemAttachment monetarySystemAttachment = (MonetarySystemAttachment)((Object)childTransactionImpl.getAttachment());
        CurrencyFreezeMonitor.checkLiquid(monetarySystemAttachment.getCurrencyId());
    }

    protected abstract void validateAttachment(ChildTransactionImpl var1, Att var2) throws NxtException.ValidationException;

    @Override
    public final byte getType() {
        return 5;
    }

    @Override
    public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
        MonetarySystemAttachment monetarySystemAttachment = (MonetarySystemAttachment)((Object)transaction.getAttachment());
        Currency currency = Currency.getCurrency(monetarySystemAttachment.getCurrencyId());
        String string = currency.getName().toLowerCase(Locale.ROOT);
        String string2 = currency.getCode().toLowerCase(Locale.ROOT);
        boolean bl = TransactionType.isDuplicate(CURRENCY_ISSUANCE, string, map, false);
        if (!string.equals(string2)) {
            bl = bl || TransactionType.isDuplicate(CURRENCY_ISSUANCE, string2, map, false);
        }
        return bl;
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }

    static abstract class MonetarySystemExchange
    extends MonetarySystemTransactionType<ExchangeAttachment> {
        MonetarySystemExchange() {
        }

        @Override
        public final void validateAttachment(ChildTransactionImpl childTransactionImpl, ExchangeAttachment exchangeAttachment) throws NxtException.ValidationException {
            if (exchangeAttachment.getRateNQT() <= 0L || exchangeAttachment.getUnitsQNT() == 0L) {
                throw new NxtException.NotValidException("Invalid exchange: " + exchangeAttachment.getJSONObject());
            }
            Currency currency = Currency.getCurrency(exchangeAttachment.getCurrencyId());
            CurrencyType.validate(currency, (Transaction)childTransactionImpl);
            if (!currency.isActive()) {
                throw new NxtException.NotCurrentlyValidException("Currency not active: " + exchangeAttachment.getJSONObject());
            }
            long l = Convert.unitRateToAmount(exchangeAttachment.getUnitsQNT(), currency.getDecimals(), exchangeAttachment.getRateNQT(), childTransactionImpl.getChain().getDecimals());
            if (l == 0L) {
                throw new NxtException.NotValidException("Currency exchange request has zero value: " + exchangeAttachment.getJSONObject());
            }
        }

        @Override
        public final boolean canHaveRecipient() {
            return false;
        }

        @Override
        public final boolean isPhasingSafe() {
            return true;
        }
    }
}

