/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import java.nio.ByteBuffer;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.ms.MonetarySystemAttachment;
import nxt.ms.MonetarySystemTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class ReserveClaimAttachment
extends Attachment.AbstractAttachment
implements MonetarySystemAttachment {
    private final long currencyId;
    private final long unitsQNT;

    public ReserveClaimAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.currencyId = byteBuffer.getLong();
        this.unitsQNT = byteBuffer.getLong();
    }

    public ReserveClaimAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.currencyId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"currency"));
        this.unitsQNT = Convert.parseLong(jSONObject.get((Object)"unitsQNT"));
    }

    public ReserveClaimAttachment(long l, long l2) {
        this.currencyId = l;
        this.unitsQNT = l2;
    }

    @Override
    protected int getMySize() {
        return 16;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.currencyId);
        byteBuffer.putLong(this.unitsQNT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"currency", (Object)Long.toUnsignedString(this.currencyId));
        jSONObject.put((Object)"unitsQNT", (Object)this.unitsQNT);
    }

    @Override
    public TransactionType getTransactionType() {
        return MonetarySystemTransactionType.RESERVE_CLAIM;
    }

    @Override
    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getUnitsQNT() {
        return this.unitsQNT;
    }
}

