/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.Transaction;
import nxt.peer.NetworkMessage;
import nxt.peer.Peer;
import nxt.peer.PeerImpl;
import nxt.peer.Peers;
import nxt.peer.TransactionsInventory;
import nxt.util.Logger;

final class BlockInventory {
    private static final ConcurrentHashMap<Long, Block> blockCache = new ConcurrentHashMap();
    private static final Set<Long> pendingBlocks = Collections.synchronizedSet(new HashSet());

    private BlockInventory() {
    }

    static NetworkMessage processRequest(PeerImpl peerImpl, NetworkMessage.BlockInventoryMessage blockInventoryMessage) {
        long l = blockInventoryMessage.getBlockId();
        long l2 = blockInventoryMessage.getPreviousBlockId();
        int n = blockInventoryMessage.getTimestamp();
        if (blockCache.get(l) != null || pendingBlocks.contains(l)) {
            return null;
        }
        Block block = Nxt.getBlockchain().getLastBlock();
        Block block2 = blockCache.get(l2);
        if (l2 == block.getId() || l2 == block.getPreviousBlockId() && n < block.getTimestamp() || block2 != null && block2.getPreviousBlockId() == block.getPreviousBlockId()) {
            if (!Nxt.getBlockchainProcessor().isDownloadSuspended()) {
                Logger.logDebugMessage("Suspending blockchain download - blockchain synchronized");
                Nxt.getBlockchainProcessor().suspendDownload(true);
            }
            pendingBlocks.add(l);
            Peers.peersService.execute(() -> {
                Peer peer = null;
                try {
                    NetworkMessage.BlocksMessage blocksMessage;
                    ArrayList<Transaction> arrayList;
                    block22: {
                        List<Peer> list;
                        List<ChainTransactionId> list2 = blockInventoryMessage.getTransactionIds();
                        BitSet bitSet = new BitSet();
                        arrayList = new ArrayList<Transaction>(list2.size());
                        for (int i = 0; i < list2.size(); ++i) {
                            list = TransactionsInventory.getCachedTransaction(list2.get(i));
                            if (list == null) continue;
                            arrayList.add((Transaction)((Object)list));
                            bitSet.set(i);
                        }
                        if (Peers.isLogLevelEnabled(2)) {
                            Logger.logDebugMessage("Requesting block " + Long.toUnsignedString(l));
                        }
                        NetworkMessage.GetBlockMessage getBlockMessage = new NetworkMessage.GetBlockMessage(l, bitSet);
                        list = Peers.getConnectedPeers();
                        if (list.isEmpty()) {
                            return;
                        }
                        int n = list.indexOf(peerImpl);
                        if (n < 0) {
                            n = 0;
                        }
                        int n2 = n;
                        do {
                            peer = (Peer)list.get(n);
                            blocksMessage = (NetworkMessage.BlocksMessage)peer.sendRequest(getBlockMessage);
                            if (blockCache.get(l) != null) {
                                return;
                            }
                            if (blocksMessage != null && blocksMessage.getBlockCount() != 0) break block22;
                        } while ((n = n < list.size() - 1 ? n + 1 : 0) != n2);
                        return;
                    }
                    Block block2 = blocksMessage.getBlock(arrayList);
                    if (Peers.isLogLevelEnabled(2)) {
                        Logger.logDebugMessage("Received block " + block2.getStringId());
                    }
                    long l2 = block2.getPreviousBlockId();
                    Block block3 = Nxt.getBlockchain().getLastBlock();
                    try {
                        if (l2 == block3.getId() || l2 == block3.getPreviousBlockId() && block2.getTimestamp() < block3.getTimestamp()) {
                            Nxt.getBlockchainProcessor().processPeerBlock(block2);
                        } else {
                            Block block4 = blockCache.get(l2);
                            if (block4 != null && block4.getPreviousBlockId() == block3.getPreviousBlockId()) {
                                ArrayList<Block> arrayList2 = new ArrayList<Block>(2);
                                arrayList2.add(block4);
                                arrayList2.add(block2);
                                Nxt.getBlockchainProcessor().processPeerBlocks(arrayList2);
                            }
                        }
                    }
                    catch (BlockchainProcessor.BlockOfLowerDifficultyException | BlockchainProcessor.BlockOutOfOrderException blockNotAcceptedException) {
                        // empty catch block
                    }
                    if (block2.getTimestamp() < Nxt.getEpochTime() + 15) {
                        blockCache.put(block2.getId(), block2);
                    }
                    int n = Nxt.getEpochTime();
                    blockCache.values().removeIf(block -> block.getTimestamp() < n - 600);
                }
                catch (RuntimeException | NxtException exception) {
                    if (peer != null) {
                        peer.blacklist(exception);
                    }
                }
                finally {
                    pendingBlocks.remove(l);
                }
            });
        } else if (l == block.getId()) {
            if (!Nxt.getBlockchainProcessor().isDownloadSuspended()) {
                Logger.logDebugMessage("Suspending blockchain download - blockchain synchronized");
                Nxt.getBlockchainProcessor().suspendDownload(true);
            }
        } else if (!Nxt.getBlockchain().hasBlock(l) && Nxt.getBlockchainProcessor().isDownloadSuspended()) {
            Logger.logDebugMessage("Resuming blockchain download - fork resolution required");
            Nxt.getBlockchainProcessor().suspendDownload(false);
        }
        return null;
    }
}

