/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import nxt.Constants;
import nxt.Nxt;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.http.APIEnum;
import nxt.peer.MessageHandler;
import nxt.peer.NetworkMessage;
import nxt.peer.Peer;
import nxt.peer.PeerImpl;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import nxt.util.UPnP;
import nxt.util.security.BlockchainPermission;

public final class NetworkHandler
implements Runnable {
    static final int DEFAULT_PEER_PORT;
    static final int TESTNET_PEER_PORT;
    static final int MAX_PENDING_MESSAGES = 25;
    private static final byte[] MESSAGE_HEADER_MAGIC;
    private static final int MESSAGE_HEADER_LENGTH;
    static final int MAX_MESSAGE_SIZE = 0x100000;
    private static final int serverPort;
    private static final boolean enablePeerUPnP;
    private static final boolean shareAddress;
    private static final int maxOutbound;
    private static final int maxInbound;
    static final int peerConnectTimeout;
    static final int peerReadTimeout;
    private static final String listenAddress;
    private static final NetworkMessage.GetInfoMessage getInfoMessage;
    private static String myAddress;
    private static String myHost;
    static String announcedAddress;
    private static final NetworkHandler listener;
    private static Thread listenerThread;
    private static final AtomicInteger inboundCount;
    private static final AtomicInteger outboundCount;
    private static ServerSocketChannel listenChannel;
    private static Selector networkSelector;
    private static final ConcurrentLinkedQueue<KeyEvent> keyEventQueue;
    static final ConcurrentHashMap<InetAddress, PeerImpl> connectionMap;
    private static volatile boolean networkStarted;
    private static volatile boolean networkShutdown;

    private NetworkHandler() {
    }

    public static void init() {
    }

    public static void shutdown() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        if (!networkShutdown) {
            networkShutdown = true;
            MessageHandler.shutdown();
            if (enablePeerUPnP) {
                UPnP.deletePort(serverPort);
            }
            if (networkSelector != null) {
                NetworkHandler.wakeup();
            }
        }
    }

    private static boolean isNetworkEnabled() {
        return !networkShutdown && Peers.isNetworkingEnabled();
    }

    private static void wakeup() {
        if (Thread.currentThread() != listenerThread) {
            networkSelector.wakeup();
        }
    }

    @Override
    public void run() {
        try {
            Logger.logDebugMessage("Network listener started");
            networkStarted = true;
            while (!networkShutdown) {
                this.processEvents();
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Logger.logInfoMessage("Server shutdown started, Network listener stopping");
        }
        catch (Throwable throwable) {
            Logger.logErrorMessage("Network listener abnormally terminated", throwable);
            networkShutdown = true;
        }
        networkStarted = false;
        Logger.logDebugMessage("Network listener stopped");
    }

    private void processEvents() {
        try {
            KeyEvent keyEvent;
            while ((keyEvent = keyEventQueue.poll()) != null) {
                keyEvent.process();
            }
            int n = networkSelector.select();
            if (n > 0 && NetworkHandler.isNetworkEnabled()) {
                Set<SelectionKey> set = networkSelector.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext() && NetworkHandler.isNetworkEnabled()) {
                    SelectionKey selectionKey = iterator.next();
                    SelectableChannel selectableChannel = selectionKey.channel();
                    if (selectableChannel.isOpen() && selectionKey.isValid()) {
                        if (selectionKey.isAcceptable()) {
                            this.processAccept(selectionKey);
                        } else if (selectionKey.isConnectable()) {
                            this.processConnect(selectionKey);
                        } else if (selectionKey.isReadable()) {
                            this.processRead(selectionKey);
                        } else if (selectionKey.isWritable()) {
                            this.processWrite(selectionKey);
                        }
                    }
                    iterator.remove();
                }
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            Logger.logDebugMessage("Network selector key cancelled - retrying", cancelledKeyException);
        }
        catch (ClosedSelectorException closedSelectorException) {
            Logger.logErrorMessage("Network selector closed unexpectedly", closedSelectorException);
            networkShutdown = true;
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("I/O error while processing selection event", iOException);
        }
    }

    static void createConnection(PeerImpl peerImpl) {
        try {
            InetAddress inetAddress = InetAddress.getByName(peerImpl.getHost());
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, peerImpl.getPort());
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            socketChannel.bind(null);
            socketChannel.connect(inetSocketAddress);
            peerImpl.setConnectionAddress(inetSocketAddress);
            peerImpl.setChannel(socketChannel);
            connectionMap.put(inetAddress, peerImpl);
            outboundCount.incrementAndGet();
            KeyEvent keyEvent = new KeyEvent(peerImpl, socketChannel, 8);
            SelectionKey selectionKey = keyEvent.register();
            if (selectionKey == null) {
                Logger.logErrorMessage("Unable to register socket channel for " + peerImpl.getHost());
            }
        }
        catch (BindException bindException) {
            Logger.logErrorMessage("Unable to bind local port: " + (bindException.getMessage() != null ? bindException.getMessage() : bindException.toString()));
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logErrorMessage("Unable to resolve host " + peerImpl.getHost() + ": " + (unknownHostException.getMessage() != null ? unknownHostException.getMessage() : unknownHostException.toString()));
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("Unable to open connection to " + peerImpl.getHost() + ": " + (iOException.getMessage() != null ? iOException.getMessage() : iOException.toString()));
        }
    }

    private void processConnect(SelectionKey selectionKey) {
        PeerImpl peerImpl = (PeerImpl)selectionKey.attachment();
        if (peerImpl == null) {
            return;
        }
        SocketChannel socketChannel = peerImpl.getChannel();
        if (socketChannel == null) {
            return;
        }
        try {
            socketChannel.finishConnect();
            if (peerImpl.getState() != Peer.State.CONNECTED) {
                KeyEvent keyEvent = peerImpl.getKeyEvent();
                if (keyEvent != null) {
                    keyEvent.update(1, 8);
                }
                peerImpl.connectComplete(true);
                NetworkHandler.sendGetInfoMessage(peerImpl);
            }
        }
        catch (IOException iOException) {
            if (iOException instanceof SocketException && iOException.getMessage() != null) {
                Logger.logDebugMessage("Outbound connect failed to complete: %s", iOException.getMessage());
            } else {
                Logger.logDebugMessage("Outbound connect failed to complete", iOException);
            }
            Peers.peersService.execute(() -> peerImpl.connectComplete(false));
        }
    }

    private void processAccept(SelectionKey selectionKey) {
        try {
            SocketChannel socketChannel = listenChannel.accept();
            if (socketChannel != null) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketChannel.getRemoteAddress();
                String string = inetSocketAddress.getAddress().getHostAddress();
                PeerImpl peerImpl = Peers.findOrCreatePeer(inetSocketAddress.getAddress());
                if (peerImpl == null) {
                    socketChannel.close();
                    Logger.logDebugMessage("Peer not accepted: Connection rejected from " + string);
                } else if (!Peers.shouldGetMorePeers()) {
                    socketChannel.close();
                    Logger.logDebugMessage("New peers are not accepted: Connection rejected from " + string);
                } else if (inboundCount.get() >= maxInbound) {
                    socketChannel.close();
                    Logger.logDebugMessage("Max inbound connections reached: Connection rejected from " + string);
                } else if (peerImpl.isBlacklisted()) {
                    socketChannel.close();
                    Logger.logDebugMessage("Peer is blacklisted: Connection rejected from " + string);
                } else if (connectionMap.get(inetSocketAddress.getAddress()) != null) {
                    socketChannel.close();
                    Logger.logDebugMessage("Connection already established with " + string + ", disconnecting");
                    peerImpl.disconnectPeer();
                } else {
                    socketChannel.configureBlocking(false);
                    peerImpl.setConnectionAddress(inetSocketAddress);
                    peerImpl.setChannel(socketChannel);
                    peerImpl.setLastUpdated(Nxt.getEpochTime());
                    connectionMap.put(inetSocketAddress.getAddress(), peerImpl);
                    inboundCount.incrementAndGet();
                    Peers.addPeer(peerImpl);
                    KeyEvent keyEvent = new KeyEvent(peerImpl, socketChannel, 0);
                    SelectionKey selectionKey2 = keyEvent.register();
                    if (selectionKey2 == null) {
                        Logger.logErrorMessage("Unable to register socket channel for " + peerImpl.getHost());
                    } else {
                        peerImpl.setInbound();
                    }
                }
            }
        }
        catch (IOException iOException) {
            Logger.logErrorMessage("Unable to accept connection", iOException);
            networkShutdown = true;
        }
    }

    private void processRead(SelectionKey selectionKey) {
        block12: {
            PeerImpl peerImpl = (PeerImpl)selectionKey.attachment();
            SocketChannel socketChannel = peerImpl.getChannel();
            if (socketChannel == null) {
                return;
            }
            ByteBuffer byteBuffer = peerImpl.getInputBuffer();
            peerImpl.setLastUpdated(Nxt.getEpochTime());
            try {
                KeyEvent keyEvent;
                do {
                    Object object;
                    if (byteBuffer == null) {
                        byteBuffer = ByteBuffer.wrap(new byte[MESSAGE_HEADER_LENGTH]);
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        peerImpl.setInputBuffer(byteBuffer);
                    }
                    if (byteBuffer.position() < byteBuffer.limit()) {
                        int n = socketChannel.read(byteBuffer);
                        if (n <= 0) {
                            if (n < 0) {
                                Logger.logDebugMessage("Connection with " + peerImpl.getHost() + " closed by peer");
                                object = peerImpl.getKeyEvent();
                                if (object != null) {
                                    ((KeyEvent)object).update(0, 5);
                                }
                                peerImpl.disconnectPeer();
                            }
                            break block12;
                        }
                        peerImpl.updateDownloadedVolume(n);
                    }
                    if (byteBuffer.position() != byteBuffer.limit() || byteBuffer.limit() != MESSAGE_HEADER_LENGTH) continue;
                    byteBuffer.position(0);
                    object = new byte[MESSAGE_HEADER_MAGIC.length];
                    byteBuffer.get((byte[])object);
                    int n = byteBuffer.getInt();
                    int n2 = n & Integer.MAX_VALUE;
                    if (!Arrays.equals((byte[])object, MESSAGE_HEADER_MAGIC)) {
                        throw new IOException("Incorrect message header " + Arrays.toString((byte[])object));
                    }
                    if (n2 < 1 || n2 > 0x100020) {
                        throw new IOException("Invalid message length " + n2);
                    }
                    byte[] byArray = new byte[MESSAGE_HEADER_LENGTH + n2];
                    byteBuffer = ByteBuffer.wrap(byArray);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    byteBuffer.put((byte[])object);
                    byteBuffer.putInt(n);
                    peerImpl.setInputBuffer(byteBuffer);
                } while (byteBuffer.position() != byteBuffer.limit());
                peerImpl.setInputBuffer(null);
                byteBuffer.position(MESSAGE_HEADER_LENGTH);
                int n = peerImpl.incrementInputCount();
                if (n >= 25 && (keyEvent = peerImpl.getKeyEvent()) != null) {
                    keyEvent.update(0, 1);
                }
                MessageHandler.processMessage(peerImpl, byteBuffer);
            }
            catch (IOException iOException) {
                NetworkHandler.disconnectAndBlacklist(peerImpl, iOException);
            }
        }
    }

    static ByteBuffer getMessageBytes(PeerImpl peerImpl, NetworkMessage networkMessage) {
        ByteBuffer byteBuffer;
        byte[] byArray = peerImpl.getSessionKey();
        int n = networkMessage.getLength();
        if (byArray != null) {
            byteBuffer = ByteBuffer.allocate(MESSAGE_HEADER_LENGTH + n + 32);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            networkMessage.getBytes(byteBuffer);
            int n2 = byteBuffer.position();
            byte[] byArray2 = new byte[n2];
            byteBuffer.position(0);
            byteBuffer.get(byArray2);
            byte[] byArray3 = Crypto.aesGCMEncrypt(byArray2, byArray);
            byteBuffer.position(0);
            byteBuffer.put(MESSAGE_HEADER_MAGIC);
            byteBuffer.putInt(byArray3.length | Integer.MIN_VALUE);
            byteBuffer.put(byArray3);
        } else {
            byteBuffer = ByteBuffer.allocate(MESSAGE_HEADER_LENGTH + n);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.put(MESSAGE_HEADER_MAGIC);
            byteBuffer.putInt(n);
            networkMessage.getBytes(byteBuffer);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processWrite(SelectionKey selectionKey) {
        PeerImpl peerImpl = (PeerImpl)selectionKey.attachment();
        SocketChannel socketChannel = peerImpl.getChannel();
        if (socketChannel == null) {
            return;
        }
        ByteBuffer byteBuffer = peerImpl.getOutputBuffer();
        try {
            while (true) {
                int n;
                if (byteBuffer == null) {
                    byteBuffer = peerImpl.getQueuedMessage();
                    if (byteBuffer == null) {
                        KeyEvent keyEvent = peerImpl.getKeyEvent();
                        if (keyEvent == null) return;
                        keyEvent.update(0, 4);
                        return;
                    }
                    peerImpl.setOutputBuffer(byteBuffer);
                }
                if ((n = socketChannel.write(byteBuffer)) > 0) {
                    peerImpl.updateUploadedVolume(n);
                }
                if (byteBuffer.position() < byteBuffer.limit()) return;
                byteBuffer = null;
                peerImpl.setOutputBuffer(null);
            }
        }
        catch (IOException iOException) {
            NetworkHandler.disconnectAndBlacklist(peerImpl, iOException);
        }
    }

    private static void disconnectAndBlacklist(PeerImpl peerImpl, Exception exception) {
        Logger.logDebugMessage(String.format("%s: Peer %s", exception.getMessage(), peerImpl.getHost()));
        KeyEvent keyEvent = peerImpl.getKeyEvent();
        if (keyEvent != null) {
            keyEvent.update(0, 5);
        }
        peerImpl.blacklist(exception);
    }

    static void closeConnection(PeerImpl peerImpl) {
        SocketChannel socketChannel = peerImpl.getChannel();
        if (socketChannel == null) {
            Logger.logDebugMessage("Channel already null when disconnecting " + peerImpl.getHost());
            if (peerImpl.getConnectionAddress() != null && connectionMap.remove(peerImpl.getConnectionAddress().getAddress()) != null) {
                Logger.logDebugMessage("Removed stale connection from connection map");
            }
            return;
        }
        try {
            if (peerImpl.isInbound()) {
                inboundCount.decrementAndGet();
            } else {
                outboundCount.decrementAndGet();
            }
            connectionMap.remove(peerImpl.getConnectionAddress().getAddress());
            if (socketChannel.isOpen()) {
                socketChannel.close();
            }
        }
        catch (IOException iOException) {
            Logger.logDebugMessage("Error closing connection", iOException);
        }
    }

    static void sendGetInfoMessage(PeerImpl peerImpl) {
        getInfoMessage.setBlockchainState(Peers.getMyBlockchainState());
        peerImpl.sendMessage(getInfoMessage);
    }

    static void sendGetInfoMessage(PeerImpl peerImpl, byte[] byArray, byte[] byArray2) {
        if (!Constants.isPermissioned) {
            throw new IllegalStateException("Session key not supported");
        }
        NetworkMessage.GetInfoMessage getInfoMessage = new NetworkMessage.GetInfoMessage("Ardor", "2.2.6", NetworkHandler.getInfoMessage.getApplicationPlatform(), NetworkHandler.getInfoMessage.getShareAddress(), NetworkHandler.getInfoMessage.getAnnouncedAddress(), NetworkHandler.getInfoMessage.getApiPort(), NetworkHandler.getInfoMessage.getSslPort(), NetworkHandler.getInfoMessage.getServices(), NetworkHandler.getInfoMessage.getDisabledAPIs(), NetworkHandler.getInfoMessage.getApiServerIdleTimeout(), NetworkHandler.getInfoMessage.getSecurityToken().getPeerPublicKey());
        getInfoMessage.getSecurityToken().setSessionKey(Peers.peerSecretPhrase, byArray, byArray2);
        peerImpl.sendMessage(getInfoMessage);
    }

    public static boolean isNetworkStarted() {
        return networkStarted;
    }

    public static int broadcastMessage(NetworkMessage networkMessage) {
        return NetworkHandler.broadcastMessage(null, networkMessage);
    }

    public static int broadcastMessage(Peer peer, NetworkMessage networkMessage) {
        if (Constants.isOffline) {
            return 0;
        }
        int n = 0;
        for (Peer peer2 : connectionMap.values()) {
            if (peer2.getState() != Peer.State.CONNECTED || peer2 == peer || peer2.getBlockchainState() == Peer.BlockchainState.LIGHT_CLIENT && !networkMessage.sendToLightClient()) continue;
            peer2.sendMessage(networkMessage);
            ++n;
        }
        NetworkHandler.wakeup();
        return n;
    }

    public static int getDefaultPeerPort() {
        return Constants.isTestnet ? TESTNET_PEER_PORT : DEFAULT_PEER_PORT;
    }

    public static int getConnectionCount() {
        return inboundCount.get() + outboundCount.get();
    }

    public static int getInboundCount() {
        return inboundCount.get();
    }

    public static int getMaxInboundConnections() {
        return maxInbound;
    }

    public static int getOutboundCount() {
        return outboundCount.get();
    }

    public static int getMaxOutboundConnections() {
        return maxOutbound;
    }

    /*
     * WARNING - void declaration
     */
    static {
        Object object;
        int n = DEFAULT_PEER_PORT = Constants.isPermissioned ? 27873 : 27874;
        TESTNET_PEER_PORT = Constants.isPermissioned ? 26873 : (Constants.isAutomatedTest ? 26872 : 26874);
        MESSAGE_HEADER_MAGIC = new byte[]{3, 44, 5, -62};
        MESSAGE_HEADER_LENGTH = MESSAGE_HEADER_MAGIC.length + 4;
        serverPort = Constants.isTestnet ? TESTNET_PEER_PORT : Nxt.getIntProperty("nxt.peerServerPort", DEFAULT_PEER_PORT);
        enablePeerUPnP = Nxt.getBooleanProperty("nxt.enablePeerUPnP");
        shareAddress = Nxt.getBooleanProperty("nxt.shareMyAddress");
        maxOutbound = Nxt.getIntProperty("nxt.maxNumberOfOutboundConnections", 8);
        maxInbound = Nxt.getIntProperty("nxt.maxNumberOfInboundConnections", 64);
        peerConnectTimeout = Nxt.getIntProperty("nxt.peerConnectTimeout", 10);
        peerReadTimeout = Nxt.getIntProperty("nxt.peerReadTimeout", 10);
        listenAddress = Nxt.getStringProperty("nxt.peerServerHost", "0.0.0.0");
        try {
            myAddress = Convert.emptyToNull(Nxt.getStringProperty("nxt.myAddress"));
            if (myAddress != null) {
                myAddress = myAddress.toLowerCase().trim();
                object = new URI("http://" + myAddress);
                myHost = ((URI)object).getHost();
                int n2 = ((URI)object).getPort();
                if (myHost == null) {
                    throw new RuntimeException("nxt.myAddress is not a valid host address");
                }
                if (n2 == TESTNET_PEER_PORT && !Constants.isTestnet) {
                    throw new RuntimeException("Port " + TESTNET_PEER_PORT + " should only be used for testnet");
                }
                announcedAddress = Constants.isTestnet ? myHost : (n2 == -1 && serverPort != DEFAULT_PEER_PORT ? myHost + ":" + serverPort : (n2 == DEFAULT_PEER_PORT ? myHost : myAddress));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.logWarningMessage("Your announced address is not valid: " + uRISyntaxException.toString());
            myAddress = null;
        }
        listener = new NetworkHandler();
        inboundCount = new AtomicInteger(0);
        outboundCount = new AtomicInteger(0);
        keyEventQueue = new ConcurrentLinkedQueue();
        connectionMap = new ConcurrentHashMap();
        networkStarted = false;
        networkShutdown = false;
        if (!Constants.isOffline) {
            Object object3;
            if (serverPort == TESTNET_PEER_PORT && !Constants.isTestnet) {
                throw new RuntimeException("Port " + TESTNET_PEER_PORT + " should only be used for testnet");
            }
            object = Nxt.getStringProperty("nxt.myPlatform", System.getProperty("os.name") + " " + System.getProperty("os.arch"));
            if (((String)object).length() > 30) {
                object = ((String)object).substring(0, 30);
            }
            if (myAddress != null) {
                try {
                    InetAddress iOException;
                    InetAddress inetAddress;
                    InetAddress[] inetAddressArray;
                    InetAddress[] inetAddressArray2 = InetAddress.getAllByName(myHost);
                    boolean bl = false;
                    object3 = NetworkInterface.getNetworkInterfaces();
                    block7: while (object3.hasMoreElements()) {
                        NetworkInterface object22 = (NetworkInterface)object3.nextElement();
                        inetAddressArray = object22.getInterfaceAddresses();
                        for (InterfaceAddress interfaceAddress : inetAddressArray) {
                            inetAddress = interfaceAddress.getAddress();
                            for (InetAddress inetAddress2 : inetAddressArray2) {
                                if (!inetAddress.equals(inetAddress2)) continue;
                                bl = true;
                                break block7;
                            }
                        }
                    }
                    if (!bl && (iOException = UPnP.getExternalAddress()) != null) {
                        void var7_22;
                        inetAddressArray = inetAddressArray2;
                        int n2 = inetAddressArray.length;
                        boolean bl2 = false;
                        while (var7_22 < n2) {
                            inetAddress = inetAddressArray[var7_22];
                            if (iOException.equals(inetAddress)) {
                                bl = true;
                                break;
                            }
                            ++var7_22;
                        }
                    }
                    if (!bl) {
                        Logger.logWarningMessage("Your announced address does not match your external address");
                    }
                }
                catch (SocketException socketException) {
                    Logger.logErrorMessage("Unable to enumerate the network interfaces: " + socketException.toString());
                }
                catch (UnknownHostException unknownHostException) {
                    Logger.logWarningMessage("Your announced address is not valid: " + unknownHostException.toString());
                }
            }
            long l = 0L;
            for (Peer.Service service : Peers.myServices) {
                l |= service.getCode();
            }
            object3 = null;
            if (API.isIsOpenAPI() && !Constants.isLightClient) {
                EnumSet<APIEnum> enumSet = EnumSet.noneOf(APIEnum.class);
                enumSet.addAll(API.getDisabledApis());
                API.getDisabledApiTags().forEach(aPITag -> {
                    for (APIEnum aPIEnum : APIEnum.values()) {
                        if (aPIEnum.getHandler() == null || !aPIEnum.getHandler().getAPITags().contains(aPITag)) continue;
                        enumSet.add(aPIEnum);
                    }
                });
                object3 = APIEnum.enumSetToBase64String(enumSet);
            }
            if (Constants.isPermissioned && Peers.peerSecretPhrase == null) {
                networkShutdown = true;
                throw new RuntimeException("Peer credentials not specified for permissioned blockchain");
            }
            getInfoMessage = new NetworkMessage.GetInfoMessage("Ardor", "2.2.6", (String)object, shareAddress, announcedAddress, API.getOpenAPIPort(), API.getOpenAPISSLPort(), l, (String)object3, API.apiServerIdleTimeout, Constants.isPermissioned ? Crypto.getPublicKey(Peers.peerSecretPhrase) : null);
            try {
                networkSelector = Selector.open();
                listenChannel = ServerSocketChannel.open();
                listenChannel.configureBlocking(false);
                listenChannel.bind(new InetSocketAddress(listenAddress, serverPort), 10);
                listenChannel.register(networkSelector, 16);
            }
            catch (IOException iOException) {
                networkShutdown = true;
                throw new RuntimeException("Unable to create network listener", iOException);
            }
            ThreadPool.runAfterStart(() -> {
                if (enablePeerUPnP) {
                    UPnP.addPort(serverPort);
                }
                listenerThread = new Thread((Runnable)listener, "Network Listener");
                listenerThread.setDaemon(true);
                listenerThread.start();
                for (int i = 1; i <= 4; ++i) {
                    MessageHandler messageHandler = new MessageHandler();
                    Thread thread = new Thread((Runnable)messageHandler, "Message Handler " + i);
                    thread.setDaemon(true);
                    thread.start();
                }
            });
        } else {
            networkShutdown = true;
            getInfoMessage = null;
            Logger.logInfoMessage("Network handler is offline");
        }
    }

    static class KeyEvent {
        private final PeerImpl peer;
        private final SocketChannel channel;
        private int addOps;
        private int removeOps;
        private SelectionKey key = null;
        private final CyclicBarrier cyclicBarrier = new CyclicBarrier(2);

        private KeyEvent(PeerImpl peerImpl, SocketChannel socketChannel, int n) {
            this.peer = peerImpl;
            this.channel = socketChannel;
            this.addOps = n;
        }

        private SelectionKey register() {
            if (Thread.currentThread() == listenerThread) {
                this.registerChannel();
                return this.key;
            }
            keyEventQueue.add(this);
            networkSelector.wakeup();
            try {
                this.cyclicBarrier.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | BrokenBarrierException | TimeoutException exception) {
                throw new IllegalStateException("Thread interrupted while waiting for key event completion", exception);
            }
            this.cyclicBarrier.reset();
            return this.key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(int n, int n2) {
            if (this.peer.isDisconnectPending()) {
                Logger.logDebugMessage("Disconnect pending");
                return;
            }
            if (Thread.currentThread() == listenerThread) {
                if (this.key.isValid()) {
                    this.key.interestOps((this.key.interestOps() | n) & ~n2);
                }
            } else {
                KeyEvent keyEvent = this;
                synchronized (keyEvent) {
                    this.cyclicBarrier.reset();
                    this.addOps = n;
                    this.removeOps = n2;
                    keyEventQueue.add(this);
                    networkSelector.wakeup();
                    try {
                        this.cyclicBarrier.await(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | BrokenBarrierException | TimeoutException exception) {
                        throw new IllegalStateException("Thread interrupted while waiting for key event completion", exception);
                    }
                }
            }
        }

        private void process() {
            try {
                if (this.key == null) {
                    this.registerChannel();
                } else if (this.key.isValid()) {
                    this.key.interestOps((this.key.interestOps() | this.addOps) & ~this.removeOps);
                }
                this.cyclicBarrier.await(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | BrokenBarrierException | TimeoutException exception) {
                Logger.logErrorMessage("Listener thread interrupted while waiting for key event completion", exception);
            }
        }

        private void registerChannel() {
            try {
                this.key = this.channel.register(networkSelector, this.addOps);
                this.key.attach(this.peer);
                this.peer.setKeyEvent(this);
            }
            catch (IOException iOException) {
                Logger.logDebugMessage("Failed to register channel", iOException);
            }
        }

        SelectionKey getKey() {
            return this.key;
        }
    }
}

