/*
 * Decompiled with CFR 0.152.
 */
package nxt.peer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.blockchain.BlockchainProcessor;
import nxt.http.API;
import nxt.http.APIEnum;
import nxt.peer.MessageHandler;
import nxt.peer.NetworkHandler;
import nxt.peer.NetworkMessage;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;

final class PeerImpl
implements Peer {
    private final String host;
    private volatile boolean isInbound = false;
    private volatile String announcedAddress;
    private volatile boolean shareAddress = false;
    private volatile String platform;
    private volatile String application;
    private volatile int port;
    private volatile int apiPort;
    private volatile int apiSSLPort;
    private volatile String version;
    private volatile EnumSet<APIEnum> disabledAPIs;
    private volatile int apiServerIdleTimeout;
    private volatile boolean isOldVersion = false;
    private volatile int blacklistingTime;
    private volatile String blacklistingCause;
    private volatile int lastUpdated = Integer.MIN_VALUE;
    private volatile int lastConnectAttempt = Integer.MIN_VALUE;
    private volatile long services;
    private volatile Peer.BlockchainState blockchainState;
    private volatile Peer.State state = Peer.State.NON_CONNECTED;
    private volatile boolean disconnectPending;
    private volatile long downloadedVolume;
    private volatile long uploadedVolume;
    private InetSocketAddress connectionAddress;
    private SocketChannel channel;
    private NetworkHandler.KeyEvent keyEvent;
    private byte[] sessionKey;
    private final ConcurrentLinkedQueue<ByteBuffer> outputQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<NetworkMessage> pendingOutputQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<ByteBuffer> pendingInputQueue = new ConcurrentLinkedQueue();
    private ByteBuffer handshakeMessage;
    private ByteBuffer inputBuffer;
    private volatile int inputCount;
    private ByteBuffer outputBuffer;
    private final ConcurrentHashMap<Long, ResponseEntry> responseMap = new ConcurrentHashMap();
    private final ReentrantLock connectLock = new ReentrantLock();
    private final Condition connectCondition = this.connectLock.newCondition();
    private volatile boolean connectPending = false;
    private volatile boolean handshakePending = false;

    PeerImpl(InetAddress inetAddress, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("peers"));
        }
        this.host = inetAddress.getHostAddress();
        this.setAnnouncedAddress(string != null ? string.toLowerCase().trim() : this.host);
        this.disabledAPIs = EnumSet.noneOf(APIEnum.class);
        this.apiServerIdleTimeout = API.apiServerIdleTimeout;
        this.blockchainState = Peer.BlockchainState.UP_TO_DATE;
    }

    void remove() {
        this.disconnectPeer();
        Peers.removePeer(this);
    }

    @Override
    public Peer.State getState() {
        return this.state;
    }

    private synchronized void setState(Peer.State state) {
        if (this.state != state) {
            if (this.state == Peer.State.NON_CONNECTED) {
                this.state = state;
                Peers.notifyListeners(this, Peers.Event.ADD_ACTIVE_PEER);
            } else if (state != Peer.State.NON_CONNECTED) {
                this.state = state;
                Peers.notifyListeners(this, Peers.Event.CHANGE_ACTIVE_PEER);
            } else {
                this.state = state;
            }
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getAnnouncedAddress() {
        return this.announcedAddress;
    }

    void setAnnouncedAddress(String string) {
        if (string == null) {
            this.announcedAddress = this.host;
            this.port = -1;
        } else {
            if (string.length() > 100) {
                throw new IllegalArgumentException("Announced address too long: " + string.length());
            }
            this.announcedAddress = string;
            try {
                this.port = new URI("http://" + string).getPort();
            }
            catch (URISyntaxException uRISyntaxException) {
                this.port = -1;
            }
        }
    }

    @Override
    public int getPort() {
        return this.port <= 0 ? NetworkHandler.getDefaultPeerPort() : this.port;
    }

    @Override
    public long getDownloadedVolume() {
        return this.downloadedVolume;
    }

    void updateDownloadedVolume(long l) {
        this.downloadedVolume += l;
    }

    @Override
    public long getUploadedVolume() {
        return this.uploadedVolume;
    }

    void updateUploadedVolume(long l) {
        this.uploadedVolume += l;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    boolean setVersion(String string) {
        if (string != null && string.length() > 10) {
            throw new IllegalArgumentException("Invalid version length: " + string.length());
        }
        boolean bl = string == null || !string.equals(this.version);
        this.version = string;
        this.isOldVersion = false;
        if ("Ardor".equals(this.application)) {
            this.isOldVersion = Peers.isOldVersion(string, Constants.MIN_VERSION);
            if (this.isOldVersion) {
                if (bl) {
                    Logger.logDebugMessage(String.format("Blacklisting %s version %s", this.getHost(), string));
                }
                this.blacklist("Old version: " + string);
            }
        }
        return !this.isOldVersion;
    }

    @Override
    public String getApplication() {
        return this.application;
    }

    void setApplication(String string) {
        if (string == null || string.length() > 20) {
            throw new IllegalArgumentException("Invalid application");
        }
        this.application = string;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    void setPlatform(String string) {
        if (string != null && string.length() > 30) {
            throw new IllegalArgumentException("Invalid platform length: " + string.length());
        }
        this.platform = string;
    }

    @Override
    public String getSoftware() {
        return Convert.truncate(this.application, "?", 10, false) + " (" + Convert.truncate(this.version, "?", 10, false) + ") @ " + Convert.truncate(this.platform, "?", 10, false);
    }

    @Override
    public int getApiPort() {
        return this.apiPort;
    }

    void setApiPort(int n) {
        this.apiPort = n;
    }

    @Override
    public int getApiSSLPort() {
        return this.apiSSLPort;
    }

    void setApiSSLPort(int n) {
        this.apiSSLPort = n;
    }

    @Override
    public Set<APIEnum> getDisabledAPIs() {
        return Collections.unmodifiableSet(this.disabledAPIs);
    }

    void setDisabledAPIs(String string) {
        this.disabledAPIs = APIEnum.base64StringToEnumSet(string);
    }

    @Override
    public int getApiServerIdleTimeout() {
        return this.apiServerIdleTimeout;
    }

    void setApiServerIdleTimeout(int n) {
        this.apiServerIdleTimeout = n;
    }

    @Override
    public Peer.BlockchainState getBlockchainState() {
        return this.blockchainState;
    }

    void setBlockchainState(Peer.BlockchainState blockchainState) {
        this.blockchainState = blockchainState;
    }

    @Override
    public boolean shareAddress() {
        return this.shareAddress;
    }

    void setShareAddress(boolean bl) {
        this.shareAddress = bl;
    }

    @Override
    public boolean isBlacklisted() {
        return this.blacklistingTime > 0 || this.isOldVersion || Peers.knownBlacklistedPeers.contains(this.getHost()) || this.announcedAddress != null && Peers.knownBlacklistedPeers.contains(this.announcedAddress);
    }

    @Override
    public String getBlacklistingCause() {
        return this.blacklistingCause;
    }

    @Override
    public void blacklist(Exception exception) {
        if (exception instanceof NxtException.NotCurrentlyValidException || exception instanceof BlockchainProcessor.BlockOutOfOrderException || exception instanceof SQLException || exception.getCause() instanceof SQLException) {
            return;
        }
        if (!this.isBlacklisted()) {
            if (exception instanceof IOException || exception instanceof IllegalArgumentException) {
                Logger.logDebugMessage("Blacklisting " + this.host + " because of: " + exception.toString());
            } else {
                Logger.logDebugMessage("Blacklisting " + this.host + " because of: " + exception.toString(), exception);
            }
        }
        this.blacklist(exception.toString() == null || Peers.hideErrorDetails ? exception.getClass().getName() : exception.toString());
    }

    @Override
    public void blacklist(String string) {
        this.blacklistingTime = Nxt.getEpochTime();
        this.blacklistingCause = string;
        this.disconnectPeer();
        Peers.notifyListeners(this, Peers.Event.BLACKLIST);
    }

    @Override
    public void unBlacklist() {
        if (this.blacklistingTime == 0) {
            return;
        }
        Logger.logDebugMessage("Unblacklisting " + this.host);
        this.blacklistingTime = 0;
        this.blacklistingCause = null;
        Peers.notifyListeners(this, Peers.Event.UNBLACKLIST);
    }

    void updateBlacklistedStatus(int n) {
        if (this.blacklistingTime > 0 && this.blacklistingTime + Peers.blacklistingPeriod <= n) {
            this.unBlacklist();
        }
        if (this.isOldVersion && this.lastUpdated < n - 3600) {
            this.isOldVersion = false;
        }
    }

    @Override
    public int getLastUpdated() {
        return this.lastUpdated;
    }

    void setLastUpdated(int n) {
        this.lastUpdated = n;
    }

    @Override
    public int getLastConnectAttempt() {
        return this.lastConnectAttempt;
    }

    void setLastConnectAttempt(int n) {
        this.lastConnectAttempt = n;
    }

    boolean verifyAnnouncedAddress(String string) {
        if (string == null) {
            return true;
        }
        try {
            URI uRI = new URI("http://" + string);
            InetAddress inetAddress = InetAddress.getByName(this.host);
            for (InetAddress inetAddress2 : InetAddress.getAllByName(uRI.getHost())) {
                if (!inetAddress2.equals(inetAddress)) continue;
                return true;
            }
            Logger.logDebugMessage("Announced address " + string + " does not resolve to " + this.host);
        }
        catch (URISyntaxException | UnknownHostException exception) {
            Logger.logDebugMessage(exception.toString());
            this.blacklist(exception);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addService(Peer.Service service, boolean bl) {
        boolean bl2;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            bl2 = (this.services & service.getCode()) == 0L;
            this.services |= service.getCode();
        }
        if (bl2 && bl) {
            Peers.notifyListeners(this, Peers.Event.CHANGE_SERVICES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeService(Peer.Service service, boolean bl) {
        boolean bl2;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            bl2 = (this.services & service.getCode()) != 0L;
            this.services &= service.getCode() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (bl2 && bl) {
            Peers.notifyListeners(this, Peers.Event.CHANGE_SERVICES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getServices() {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            return this.services;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServices(long l) {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            this.services = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean providesService(Peer.Service service) {
        boolean bl;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            bl = (this.services & service.getCode()) != 0L;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean providesServices(long l) {
        boolean bl;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            bl = (l & this.services) == l;
        }
        return bl;
    }

    InetSocketAddress getConnectionAddress() {
        return this.connectionAddress;
    }

    void setConnectionAddress(InetSocketAddress inetSocketAddress) {
        this.connectionAddress = inetSocketAddress;
    }

    SocketChannel getChannel() {
        return this.channel;
    }

    void setChannel(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    NetworkHandler.KeyEvent getKeyEvent() {
        return this.keyEvent;
    }

    void setKeyEvent(NetworkHandler.KeyEvent keyEvent) {
        this.keyEvent = keyEvent;
    }

    ByteBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    void setInputBuffer(ByteBuffer byteBuffer) {
        this.inputBuffer = byteBuffer;
    }

    synchronized int getInputCount() {
        return this.inputCount;
    }

    synchronized int incrementInputCount() {
        return ++this.inputCount;
    }

    synchronized int decrementInputCount() {
        this.inputCount = this.inputCount > 0 ? (this.inputCount = this.inputCount - 1) : 0;
        return this.inputCount;
    }

    ByteBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    void setOutputBuffer(ByteBuffer byteBuffer) {
        this.outputBuffer = byteBuffer;
    }

    @Override
    public boolean isInbound() {
        return this.isInbound;
    }

    void setInbound() {
        this.connectLock.lock();
        try {
            if (this.state != Peer.State.CONNECTED && this.keyEvent != null) {
                this.isInbound = true;
                this.handshakePending = true;
                this.setState(Peer.State.CONNECTED);
                this.keyEvent.update(1, 0);
                Logger.logInfoMessage("Connection from " + this.host + " accepted");
            } else {
                Logger.logInfoMessage("Did not accept connection from " + this.host + ", peer state is " + (Object)((Object)this.state));
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public void connectPeer() {
        this.connectLock.lock();
        try {
            if (this.state != Peer.State.CONNECTED) {
                if (!this.connectPending) {
                    this.unBlacklist();
                    this.isOldVersion = false;
                    this.setLastConnectAttempt(Nxt.getEpochTime());
                    NetworkHandler.createConnection(this);
                    this.connectPending = true;
                }
                if (!this.connectCondition.await(NetworkHandler.peerConnectTimeout, TimeUnit.SECONDS) && this.connectPending) {
                    Logger.logDebugMessage("Timeout trying to connect to " + this.host);
                    this.disconnectPeer();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.logDebugMessage("Connect to " + this.host + " interrupted");
        }
        catch (Exception exception) {
            Logger.logErrorMessage("Unable to wait for connect to complete", exception);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    void connectComplete(boolean bl) {
        this.connectLock.lock();
        try {
            if (this.connectPending) {
                this.connectPending = false;
                this.connectCondition.signalAll();
            }
            if (bl && this.channel != null) {
                this.handshakePending = true;
                this.lastUpdated = Nxt.getEpochTime();
                this.setState(Peer.State.CONNECTED);
                Logger.logInfoMessage("Connection to " + this.host + " completed");
            } else {
                Logger.logInfoMessage("Connection to " + this.host + " failed to complete, disconnecting");
                this.disconnectPeer();
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    boolean isHandshakePending() {
        return this.handshakePending;
    }

    synchronized void handshakeComplete() {
        Logger.logDebugMessage("Handshake complete with " + this.getHost());
        this.handshakePending = false;
        while (!this.pendingInputQueue.isEmpty()) {
            MessageHandler.processMessage(this, this.pendingInputQueue.poll());
        }
        while (!this.pendingOutputQueue.isEmpty()) {
            this.outputQueue.offer(NetworkHandler.getMessageBytes(this, this.pendingOutputQueue.poll()));
        }
        if (!this.outputQueue.isEmpty()) {
            try {
                this.keyEvent.update(4, 0);
            }
            catch (IllegalStateException illegalStateException) {
                Logger.logErrorMessage("Unable to update network selection key", illegalStateException);
            }
        }
    }

    synchronized void queueInputMessage(ByteBuffer byteBuffer) {
        if (this.handshakePending) {
            this.pendingInputQueue.offer(byteBuffer);
        } else {
            MessageHandler.processMessage(this, byteBuffer);
        }
    }

    boolean isDisconnectPending() {
        return this.disconnectPending;
    }

    @Override
    public void disconnectPeer() {
        if (this.disconnectPending) {
            return;
        }
        this.disconnectPending = true;
        this.connectLock.lock();
        try {
            if (!this.disconnectPending) {
                Logger.logDebugMessage("Disconnect no longer pending");
                return;
            }
            if (this.state == Peer.State.CONNECTED) {
                Logger.logInfoMessage("Will close connection to " + this.host);
            }
            this.setState(Peer.State.DISCONNECTED);
            if (this.connectPending) {
                this.connectPending = false;
                this.connectCondition.signalAll();
            }
            NetworkHandler.closeConnection(this);
            this.outputQueue.clear();
            this.pendingOutputQueue.clear();
            this.pendingInputQueue.clear();
            for (ResponseEntry responseEntry : this.responseMap.values()) {
                responseEntry.responseSignal(null);
            }
            this.responseMap.clear();
            this.isInbound = false;
            this.handshakePending = false;
            this.handshakeMessage = null;
            this.downloadedVolume = 0L;
            this.uploadedVolume = 0L;
            this.inputBuffer = null;
            this.outputBuffer = null;
            this.inputCount = 0;
            this.channel = null;
            this.keyEvent = null;
            this.connectionAddress = null;
            this.sessionKey = null;
        }
        finally {
            this.disconnectPending = false;
            this.connectLock.unlock();
        }
    }

    byte[] getSessionKey() {
        return this.sessionKey;
    }

    void setSessionKey(byte[] byArray) {
        this.sessionKey = byArray;
    }

    synchronized ByteBuffer getQueuedMessage() {
        ByteBuffer byteBuffer;
        if (this.disconnectPending) {
            byteBuffer = null;
        } else if (this.handshakeMessage != null) {
            byteBuffer = this.handshakeMessage;
            this.handshakeMessage = null;
        } else {
            byteBuffer = this.handshakePending ? null : this.outputQueue.poll();
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(NetworkMessage networkMessage) {
        block18: {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            PeerImpl peerImpl = this;
            synchronized (peerImpl) {
                if (this.state == Peer.State.CONNECTED && !this.disconnectPending) {
                    if (this.handshakePending && networkMessage instanceof NetworkMessage.GetInfoMessage) {
                        this.handshakeMessage = NetworkHandler.getMessageBytes(this, networkMessage);
                        bl = true;
                    } else if (this.outputQueue.size() >= 25) {
                        Logger.logErrorMessage("Too many pending messages for " + this.host);
                        bl3 = true;
                    } else if (this.handshakePending) {
                        this.pendingOutputQueue.offer(networkMessage);
                    } else {
                        bl2 = true;
                        bl = true;
                    }
                } else {
                    Logger.logDebugMessage("Flushing " + networkMessage.getMessageName() + " message because " + this.host + " is not connected");
                    bl3 = true;
                }
            }
            if (bl2 && !this.disconnectPending) {
                this.outputQueue.offer(NetworkHandler.getMessageBytes(this, networkMessage));
            }
            if (bl) {
                try {
                    if (this.keyEvent == null) break block18;
                    this.keyEvent.update(4, 0);
                    if (Peers.isLogLevelEnabled(1)) {
                        Logger.logDebugMessage(String.format("%s[%d] message sent to %s", networkMessage.getMessageName(), networkMessage.getMessageId(), this.host));
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    Logger.logErrorMessage("Unable to update network selection key", illegalStateException);
                }
            } else if (bl3) {
                this.disconnectPeer();
            }
        }
    }

    @Override
    public NetworkMessage sendRequest(NetworkMessage networkMessage) {
        if (this.state != Peer.State.CONNECTED || this.disconnectPending) {
            return null;
        }
        ResponseEntry responseEntry = new ResponseEntry();
        this.responseMap.put(networkMessage.getMessageId(), responseEntry);
        this.sendMessage(networkMessage);
        if (this.state != Peer.State.CONNECTED) {
            this.responseMap.remove(networkMessage.getMessageId());
            return null;
        }
        NetworkMessage networkMessage2 = responseEntry.responseWait();
        this.responseMap.remove(networkMessage.getMessageId());
        if (networkMessage2 == null) {
            this.disconnectPeer();
            return null;
        }
        if (networkMessage2 instanceof NetworkMessage.ErrorMessage) {
            NetworkMessage.ErrorMessage errorMessage = (NetworkMessage.ErrorMessage)networkMessage2;
            if (errorMessage.isSevereError()) {
                Logger.logDebugMessage(String.format("Error returned by %s for %s[%d] message: %s", this.host, errorMessage.getErrorName(), errorMessage.getMessageId(), errorMessage.getErrorMessage()));
                this.disconnectPeer();
            }
            return null;
        }
        return networkMessage2;
    }

    void completeRequest(NetworkMessage networkMessage) {
        ResponseEntry responseEntry = this.responseMap.get(networkMessage.getMessageId());
        if (responseEntry != null) {
            responseEntry.responseSignal(networkMessage);
        } else {
            Logger.logErrorMessage("Request not found for '" + networkMessage.getMessageName() + "' message");
        }
    }

    @Override
    public boolean isOpenAPI() {
        return this.providesService(Peer.Service.API) || this.providesService(Peer.Service.API_SSL);
    }

    @Override
    public boolean isApiConnectable() {
        return this.isOpenAPI() && this.state == Peer.State.CONNECTED && !Peers.isOldVersion(this.version, Constants.MIN_PROXY_VERSION) && !Peers.isNewVersion(this.version) && this.blockchainState == Peer.BlockchainState.UP_TO_DATE;
    }

    @Override
    public StringBuilder getPeerApiUri() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.providesService(Peer.Service.API_SSL)) {
            stringBuilder.append("https://");
        } else {
            stringBuilder.append("http://");
        }
        stringBuilder.append(this.host).append(":");
        if (this.providesService(Peer.Service.API_SSL)) {
            stringBuilder.append(this.apiSSLPort);
        } else {
            stringBuilder.append(this.apiPort);
        }
        return stringBuilder;
    }

    public String toString() {
        return "Peer{state=" + (Object)((Object)this.state) + ", announcedAddress='" + this.announcedAddress + '\'' + ", services=" + this.services + ", host='" + this.host + '\'' + ", version='" + this.version + '\'' + '}';
    }

    private class ResponseEntry {
        private final CountDownLatch responseLatch = new CountDownLatch(1);
        private NetworkMessage responseMessage;

        private ResponseEntry() {
        }

        private NetworkMessage responseWait() {
            try {
                if (!this.responseLatch.await(NetworkHandler.peerReadTimeout, TimeUnit.SECONDS)) {
                    Logger.logDebugMessage("Read from " + PeerImpl.this.host + " timed out");
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.logDebugMessage("Read from " + PeerImpl.this.host + " interrupted");
            }
            return this.responseMessage;
        }

        private void responseSignal(NetworkMessage networkMessage) {
            this.responseMessage = networkMessage;
            this.responseLatch.countDown();
        }
    }
}

