/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import nxt.NxtException;
import nxt.blockchain.TransactionType;
import nxt.crypto.Crypto;
import nxt.shuffling.AbstractShufflingAttachment;
import nxt.shuffling.ShufflingTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class ShufflingCancellationAttachment
extends AbstractShufflingAttachment {
    private final byte[][] blameData;
    private final byte[][] keySeeds;
    private final long cancellingAccountId;

    ShufflingCancellationAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        int n;
        int n2 = byteBuffer.get();
        if (n2 > 30 || n2 <= 0) {
            throw new NxtException.NotValidException("Invalid data count " + n2);
        }
        this.blameData = new byte[n2][];
        for (n = 0; n < n2; ++n) {
            int n3 = byteBuffer.getInt();
            if (n3 > 131072) {
                throw new NxtException.NotValidException("Invalid data size " + n3);
            }
            this.blameData[n] = new byte[n3];
            byteBuffer.get(this.blameData[n]);
        }
        n2 = byteBuffer.get();
        if (n2 > 30 || n2 <= 0) {
            throw new NxtException.NotValidException("Invalid keySeeds count " + n2);
        }
        this.keySeeds = new byte[n2][];
        for (n = 0; n < n2; ++n) {
            this.keySeeds[n] = new byte[32];
            byteBuffer.get(this.keySeeds[n]);
        }
        this.cancellingAccountId = byteBuffer.getLong();
    }

    ShufflingCancellationAttachment(JSONObject jSONObject) {
        super(jSONObject);
        int n;
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"blameData");
        this.blameData = new byte[jSONArray.size()][];
        for (n = 0; n < this.blameData.length; ++n) {
            this.blameData[n] = Convert.parseHexString((String)jSONArray.get(n));
        }
        jSONArray = (JSONArray)jSONObject.get((Object)"keySeeds");
        this.keySeeds = new byte[jSONArray.size()][];
        for (n = 0; n < this.keySeeds.length; ++n) {
            this.keySeeds[n] = Convert.parseHexString((String)jSONArray.get(n));
        }
        this.cancellingAccountId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"cancellingAccount"));
    }

    ShufflingCancellationAttachment(byte[] byArray, byte[][] byArray2, byte[][] byArray3, byte[] byArray4, long l) {
        super(byArray, byArray4);
        this.blameData = byArray2;
        this.keySeeds = byArray3;
        this.cancellingAccountId = l;
    }

    @Override
    public TransactionType getTransactionType() {
        return ShufflingTransactionType.SHUFFLING_CANCELLATION;
    }

    @Override
    protected int getMySize() {
        int n = super.getMySize();
        ++n;
        for (byte[] byArray : this.blameData) {
            n += 4;
            n += byArray.length;
        }
        ++n;
        n += 32 * this.keySeeds.length;
        return n += 8;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        super.putMyBytes(byteBuffer);
        byteBuffer.put((byte)this.blameData.length);
        for (byte[] byArray : this.blameData) {
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
        }
        byteBuffer.put((byte)this.keySeeds.length);
        for (byte[] byArray : this.keySeeds) {
            byteBuffer.put(byArray);
        }
        byteBuffer.putLong(this.cancellingAccountId);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        super.putMyJSON(jSONObject);
        JSONArray jSONArray = new JSONArray();
        jSONObject.put((Object)"blameData", (Object)jSONArray);
        for (byte[] byArray : this.blameData) {
            jSONArray.add((Object)Convert.toHexString(byArray));
        }
        jSONArray = new JSONArray();
        jSONObject.put((Object)"keySeeds", (Object)jSONArray);
        for (byte[] byArray : this.keySeeds) {
            jSONArray.add((Object)Convert.toHexString(byArray));
        }
        if (this.cancellingAccountId != 0L) {
            jSONObject.put((Object)"cancellingAccount", (Object)Long.toUnsignedString(this.cancellingAccountId));
        }
    }

    public byte[][] getBlameData() {
        return this.blameData;
    }

    public byte[][] getKeySeeds() {
        return this.keySeeds;
    }

    public long getCancellingAccountId() {
        return this.cancellingAccountId;
    }

    public byte[] getHash() {
        MessageDigest messageDigest = Crypto.sha256();
        for (byte[] byArray : this.blameData) {
            messageDigest.update(byArray);
        }
        return messageDigest.digest();
    }
}

