/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.nio.ByteBuffer;
import nxt.account.HoldingType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.shuffling.ShufflingTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class ShufflingCreationAttachment
extends Attachment.AbstractAttachment {
    private final long holdingId;
    private final HoldingType holdingType;
    private final long amount;
    private final byte participantCount;
    private final short registrationPeriod;

    ShufflingCreationAttachment(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.holdingId = byteBuffer.getLong();
        this.holdingType = HoldingType.get(byteBuffer.get());
        this.amount = byteBuffer.getLong();
        this.participantCount = byteBuffer.get();
        this.registrationPeriod = byteBuffer.getShort();
    }

    ShufflingCreationAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.holdingId = Convert.parseUnsignedLong((String)jSONObject.get((Object)"holding"));
        this.holdingType = HoldingType.get(((Long)jSONObject.get((Object)"holdingType")).byteValue());
        this.amount = Convert.parseLong(jSONObject.get((Object)"amount"));
        this.participantCount = ((Long)jSONObject.get((Object)"participantCount")).byteValue();
        this.registrationPeriod = ((Long)jSONObject.get((Object)"registrationPeriod")).shortValue();
    }

    public ShufflingCreationAttachment(long l, HoldingType holdingType, long l2, byte by, short s) {
        this.holdingId = l;
        this.holdingType = holdingType;
        this.amount = l2;
        this.participantCount = by;
        this.registrationPeriod = s;
    }

    @Override
    protected int getMySize() {
        return 20;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putLong(this.holdingId);
        byteBuffer.put(this.holdingType.getCode());
        byteBuffer.putLong(this.amount);
        byteBuffer.put(this.participantCount);
        byteBuffer.putShort(this.registrationPeriod);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"holding", (Object)Long.toUnsignedString(this.holdingId));
        jSONObject.put((Object)"holdingType", (Object)this.holdingType.getCode());
        jSONObject.put((Object)"amount", (Object)this.amount);
        jSONObject.put((Object)"participantCount", (Object)this.participantCount);
        jSONObject.put((Object)"registrationPeriod", (Object)this.registrationPeriod);
    }

    @Override
    public TransactionType getTransactionType() {
        return ShufflingTransactionType.SHUFFLING_CREATION;
    }

    public long getHoldingId() {
        return this.holdingId;
    }

    public HoldingType getHoldingType() {
        return this.holdingType;
    }

    public long getAmount() {
        return this.amount;
    }

    public byte getParticipantCount() {
        return this.participantCount;
    }

    public short getRegistrationPeriod() {
        return this.registrationPeriod;
    }
}

