/*
 * Decompiled with CFR 0.152.
 */
package nxt.shuffling;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import nxt.NxtException;
import nxt.blockchain.Appendix;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionType;
import nxt.crypto.Crypto;
import nxt.shuffling.AbstractShufflingAttachment;
import nxt.shuffling.ShufflingTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class ShufflingProcessingAttachment
extends AbstractShufflingAttachment
implements Appendix.Prunable {
    private static final byte[] emptyDataHash = Crypto.sha256().digest();
    public static final Appendix.Parser appendixParser = new Appendix.Parser(){

        @Override
        public Appendix.AbstractAppendix parse(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new ShufflingProcessingAttachment(byteBuffer);
        }

        @Override
        public Appendix.AbstractAppendix parse(JSONObject jSONObject) {
            if (!Appendix.hasAppendix(ShufflingTransactionType.SHUFFLING_PROCESSING.getName(), jSONObject)) {
                return null;
            }
            return new ShufflingProcessingAttachment(jSONObject);
        }
    };
    private volatile byte[][] data;
    private final byte[] hash;

    ShufflingProcessingAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        byte by = byteBuffer.get();
        if ((by & 1) != 0) {
            int n = byteBuffer.get() & 0xFF;
            this.data = new byte[n][];
            for (int i = 0; i < n; ++i) {
                short s = (short)(byteBuffer.getShort() & 0xFFFF);
                if (s > 4096) {
                    throw new NxtException.NotValidException("Invalid shuffling processing data length " + s);
                }
                this.data[i] = new byte[s];
                byteBuffer.get(this.data[i]);
            }
            this.hash = null;
        } else {
            this.hash = new byte[32];
            byteBuffer.get(this.hash);
            this.data = Arrays.equals(this.hash, emptyDataHash) ? Convert.EMPTY_BYTES : (byte[][])null;
        }
    }

    ShufflingProcessingAttachment(JSONObject jSONObject) {
        super(jSONObject);
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"data");
        if (jSONArray != null) {
            this.data = new byte[jSONArray.size()][];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = Convert.parseHexString((String)jSONArray.get(i));
            }
            this.hash = null;
        } else {
            this.hash = Convert.parseHexString(Convert.emptyToNull((String)jSONObject.get((Object)"hash")));
            this.data = Arrays.equals(this.hash, emptyDataHash) ? Convert.EMPTY_BYTES : (byte[][])null;
        }
    }

    ShufflingProcessingAttachment(byte[] byArray, byte[][] byArray2, byte[] byArray3) {
        super(byArray, byArray3);
        this.data = byArray2;
        this.hash = null;
    }

    @Override
    public int getMyFullSize() {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        int n = super.getMySize() + 1;
        ++n;
        for (byte[] byArray : this.data) {
            n += 2;
            n += byArray.length;
        }
        return n;
    }

    @Override
    protected int getMySize() {
        return super.getMySize() + 1 + 32;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        super.putMyBytes(byteBuffer);
        byteBuffer.put((byte)0);
        byteBuffer.put(this.getHash());
    }

    @Override
    public void putMyPrunableBytes(ByteBuffer byteBuffer) {
        if (!this.hasPrunableData()) {
            throw new IllegalStateException("Prunable data not available");
        }
        super.putMyBytes(byteBuffer);
        byteBuffer.put((byte)1);
        byteBuffer.put((byte)this.data.length);
        for (byte[] byArray : this.data) {
            byteBuffer.putShort((short)byArray.length);
            byteBuffer.put(byArray);
        }
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        super.putMyJSON(jSONObject);
        if (this.data != null) {
            JSONArray jSONArray = new JSONArray();
            jSONObject.put((Object)"data", (Object)jSONArray);
            for (byte[] byArray : this.data) {
                jSONArray.add((Object)Convert.toHexString(byArray));
            }
        }
        jSONObject.put((Object)"hash", (Object)Convert.toHexString(this.getHash()));
    }

    @Override
    public TransactionType getTransactionType() {
        return ShufflingTransactionType.SHUFFLING_PROCESSING;
    }

    @Override
    public byte[] getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        if (this.data != null) {
            MessageDigest messageDigest = Crypto.sha256();
            for (byte[] byArray : this.data) {
                messageDigest.update(byArray);
            }
            return messageDigest.digest();
        }
        throw new IllegalStateException("Both hash and data are null");
    }

    public byte[][] getData() {
        return this.data;
    }

    @Override
    public void loadPrunable(Transaction transaction, boolean bl) {
        if (this.data == null && this.shouldLoadPrunable(transaction, bl)) {
            this.data = ((ChildChain)transaction.getChain()).getShufflingParticipantHome().getData(this.getShufflingFullHash(), transaction.getSenderId());
        }
    }

    @Override
    public boolean hasPrunableData() {
        return this.data != null;
    }

    @Override
    public void restorePrunableData(Transaction transaction, int n, int n2) {
        ((ChildChain)transaction.getChain()).getShufflingParticipantHome().restoreData(this.getShufflingFullHash(), transaction.getSenderId(), this.getData(), transaction.getTimestamp(), n2);
    }
}

