/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import nxt.Nxt;
import nxt.configuration.Setup;
import nxt.http.GetConstants;
import nxt.util.JSON;
import nxt.util.ThreadPool;
import nxt.util.security.BlockchainPermission;

public class ConstantsExporter {
    private static final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws InterruptedException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        if (stringArray.length != 1) {
            System.out.println("Usage: ConstantsExporter <destination constants.js file>");
            System.exit(1);
        }
        ThreadPool.runAfterStart(() -> {
            try {
                FileWriter fileWriter = new FileWriter(new File(stringArray[0]));
                fileWriter.write("if (!NRS) {\n    var NRS = {};\n    NRS.constants = {};\n}\n\n");
                fileWriter.write("NRS.constants.SERVER = ");
                JSON.writeJSONString(GetConstants.getConstants(), fileWriter);
                fileWriter.write(";\n\nif (isNode) {\n    module.exports = NRS.constants.SERVER;\n}\n");
                ((Writer)fileWriter).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            Nxt.shutdown();
            Object object = sync;
            synchronized (object) {
                sync.notify();
            }
        });
        Nxt.init(Setup.COMMAND_LINE_TOOL);
        Object object = sync;
        synchronized (object) {
            sync.wait();
        }
    }
}

