/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.addons.Contract;
import nxt.addons.ContractInfo;
import nxt.addons.ContractLoader;
import nxt.addons.ContractSetupParameter;
import nxt.addons.JA;
import nxt.addons.JO;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildChain;
import nxt.configuration.Setup;
import nxt.crypto.Crypto;
import nxt.http.API;
import nxt.http.JSONResponses;
import nxt.http.callers.EventRegisterCall;
import nxt.http.callers.EventWaitCall;
import nxt.http.callers.GetConstantsCall;
import nxt.http.callers.GetContractReferencesCall;
import nxt.http.callers.GetSupportedContractsCall;
import nxt.http.callers.GetTaggedDataCall;
import nxt.http.responses.TaggedDataResponseImpl;
import nxt.lightcontracts.ContractReferenceAttachment;
import nxt.lightcontracts.ContractReferenceDeleteAttachment;
import nxt.taggeddata.TaggedDataAttachment;
import nxt.tools.JDKToolsWrapper;
import nxt.tools.LocalSigner;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.ReproducibleJarOutputStream;
import nxt.util.ResourceLookup;
import nxt.util.Search;
import nxt.util.TrustAllSSLProvider;
import nxt.util.security.BlockchainPermission;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ContractManager {
    private static final String CLI_HEADER = "Use Contract Manager to Upload or Reference Lightweight Contracts";
    private static final String CONTRACT_UPLOADER_JSON_FILE = "contract.uploader.json";
    private static final String CONTRACT_MANAGER_PROPERTY_FORMAT = "contract.%s.%s";
    private static final String CONTRACT_MANAGER_PROPERTY_PARAM_FORMAT = "contract.%s.param.%s";
    private String secretPhrase;
    private long feeNQT;
    private long feeRateNQTPerFXT;
    private long minBundlerBalanceFXT;
    private ChildChain childChain;
    private JO contractSetup;
    private static URL url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        CommandLine commandLine;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("tools"));
        }
        Options options = new Options();
        Arrays.stream(OPTION.values()).forEach(oPTION -> options.addOption(new Option(oPTION.getOpt(), oPTION.getLongOpt(), oPTION.hasArgs(), oPTION.getDescription())));
        DefaultParser defaultParser = new DefaultParser();
        HelpFormatter helpFormatter = new HelpFormatter();
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            Logger.logInfoMessage(parseException.getMessage(), parseException);
            helpFormatter.printHelp(ContractManager.class.getName(), options);
            return;
        }
        List list = Arrays.stream(OPTION.values()).filter(oPTION -> commandLine.hasOption(oPTION.getOpt())).collect(Collectors.toList());
        List list2 = list.stream().filter(OPTION::isAction).collect(Collectors.toList());
        if (list2.size() != 1) {
            String string = Arrays.stream(OPTION.values()).filter(OPTION::isAction).map(oPTION -> "--" + oPTION.getLongOpt()).collect(Collectors.joining(","));
            helpFormatter.printHelp(ContractManager.class.getName(), CLI_HEADER, options, String.format("Exactly one of the arguments %s has to be specified", string));
            return;
        }
        OPTION oPTION2 = (OPTION)((Object)list2.get(0));
        OPTION[] oPTIONArray = oPTION2.getDependencies();
        String string = Arrays.stream(oPTIONArray).filter(oPTION -> !list.contains(oPTION)).map(oPTION -> "--" + oPTION.getLongOpt()).collect(Collectors.joining(","));
        if (string.length() > 0) {
            helpFormatter.printHelp(ContractManager.class.getName(), CLI_HEADER, options, String.format("Action --%s is missing the following arguments %s", oPTION2.getLongOpt(), string));
            return;
        }
        System.setProperty("nxt.logging.properties.file.name.prefix", "contract.manager.");
        Nxt.init(Setup.CLIENT_APP);
        try {
            try {
                ((GetConstantsCall)GetConstantsCall.create().remote(ContractManager.getUrl())).call();
            }
            catch (Exception exception) {
                if (exception.getCause() != null && exception.getCause() instanceof ConnectException) {
                    Logger.logErrorMessage("Cannot connect to " + ContractManager.getUrl() + " make sure the node is running");
                } else {
                    Logger.logErrorMessage("Error connecting to remote node " + ContractManager.getUrl(), exception);
                }
                Logger.logInfoMessage("==============================");
                Logger.logInfoMessage("Contract Manager Shutting Down");
                Logger.logInfoMessage("==============================");
                Nxt.shutdown();
                return;
            }
            Logger.logInfoMessage("========================");
            Logger.logInfoMessage("Contract Manager Started");
            Logger.logInfoMessage("========================");
            ContractManager contractManager = new ContractManager();
            if (oPTION2 == OPTION.LIST) {
                contractManager.list(commandLine.getOptionValue(OPTION.ACCOUNT.getOpt()), commandLine.getOptionValue(OPTION.NAME.getOpt()));
                return;
            }
            String string2 = commandLine.getOptionValue(OPTION.NAME.getOpt());
            contractManager.init(string2);
            if (oPTION2 == OPTION.UPLOAD) {
                ContractData contractData = contractManager.upload(string2, commandLine.getOptionValue(OPTION.PACKAGE.getOpt()));
                byte[] byArray = contractData.getResponse().parseHexString("fullHash");
                if (byArray == null) {
                    return;
                }
                contractManager.reference(contractData, byArray);
                contractManager.waitForNextBlock();
            } else if (oPTION2 == OPTION.REFERENCE) {
                byte[] byArray = Convert.parseHexString(commandLine.getOptionValue(OPTION.HASH.getOpt()));
                ContractData contractData = new ContractData(string2);
                contractManager.reference(contractData, byArray);
                contractManager.waitForNextBlock();
            } else if (oPTION2 == OPTION.DELETE) {
                contractManager.delete(string2);
                contractManager.waitForNextBlock();
            } else if (oPTION2 == OPTION.VERIFY) {
                contractManager.verify(commandLine.getOptionValue(OPTION.HASH.getOpt()), commandLine.getOptionValue(OPTION.SOURCE.getOpt()));
            } else {
                helpFormatter.printHelp(ContractManager.class.getName(), CLI_HEADER, options, "Should never happen");
            }
        }
        finally {
            Logger.logInfoMessage("==============================");
            Logger.logInfoMessage("Contract Manager Shutting Down");
            Logger.logInfoMessage("==============================");
            Nxt.shutdown();
        }
    }

    public void init(String string) {
        Iterable iterable;
        String string2 = "contract.manager.secretPhrase";
        this.secretPhrase = Convert.emptyToNull(Nxt.getStringProperty(string2, null, true));
        if (this.secretPhrase == null) {
            throw new IllegalArgumentException(String.format("%s not specified in nxt.properties", string2));
        }
        this.feeNQT = Nxt.getIntProperty("contract.manager.feeNQT", -1);
        this.feeRateNQTPerFXT = Nxt.getIntProperty("contract.manager.feeRateNQTPerFXT", -1);
        this.minBundlerBalanceFXT = Nxt.getIntProperty("contract.manager.minBundlerBalanceFXT", 0);
        this.childChain = ChildChain.IGNIS;
        Path path = Paths.get(Nxt.getUserHomeDir(), "conf", CONTRACT_UPLOADER_JSON_FILE);
        Logger.logInfoMessage("Loading contract upload configuration from: %s", path.toAbsolutePath());
        JO jO2 = ResourceLookup.loadJsonResource(path);
        if (jO2 == null) {
            iterable = Paths.get("./addons/resources/contract.uploader.json", new String[0]);
            try {
                Files.copy(iterable, path, new CopyOption[0]);
                Logger.logInfoMessage(String.format("Sample contract uploader params file copied from %s to %s", iterable, path));
                jO2 = ResourceLookup.loadJsonResource(path);
                if (jO2 == null) {
                    throw new IOException(String.format("Failed to create %s", path));
                }
            }
            catch (IOException iOException) {
                Logger.logErrorMessage(String.format("Cannot write or load sample contract uploader params file %s", path), iOException);
                return;
            }
        }
        iterable = jO2.getArray("contracts");
        List<JO> list = ((JA)iterable).objects();
        Logger.logInfoMessage("Contract configuration loaded for contracts: %s", list.stream().map(jO -> jO.getString("className")).collect(Collectors.joining(", ")));
        if (string == null) {
            Logger.logInfoMessage("Contract name not provided");
            return;
        }
        this.contractSetup = list.stream().filter(jO -> string.equals(jO.getString("className"))).findFirst().orElse(null);
        if (this.contractSetup == null) {
            Logger.logInfoMessage(String.format("Contract definition for contract '%s' not found in %s will use only parameters from properties file", string, path.toAbsolutePath()));
            this.contractSetup = new JO();
        }
    }

    public void list(String string, String string2) {
        JO jO;
        if (Convert.emptyToNull(string) == null) {
            try {
                jO = ((GetSupportedContractsCall)GetSupportedContractsCall.create().remote(ContractManager.getUrl())).call();
                if (!jO.isExist("contractRunnerAccountRS")) {
                    Logger.logInfoMessage("Account not specified and cannot determine contract runner account - %s", jO.toJSONString());
                    return;
                }
                string = jO.getString("contractRunnerAccountRS");
            }
            catch (Exception exception) {
                Logger.logInfoMessage("Contract runner not enabled %s", exception.getMessage());
                return;
            }
        }
        jO = this.listImpl(string, string2);
        Logger.logInfoMessage("Listing contracts for account %s", string);
        if (jO.isExist("contractReferences")) {
            List<JO> list = jO.getJoList("contractReferences");
            for (JO jO2 : list) {
                Logger.logInfoMessage(jO2.toJSONString());
            }
            Logger.logInfoMessage("End of list");
        } else {
            Logger.logInfoMessage("No contract references found");
        }
    }

    public JO listImpl(String string, String string2) {
        GetContractReferencesCall getContractReferencesCall = (GetContractReferencesCall)GetContractReferencesCall.create().account(string).remote(ContractManager.getUrl());
        if (string2 != null) {
            getContractReferencesCall.contractName(string2);
        }
        return getContractReferencesCall.call();
    }

    public ContractData upload(String string, String string2) {
        ContractData contractData = this.uploadImpl(string, string2);
        JO jO = contractData.getResponse();
        if (!jO.isExist("fullHash")) {
            Logger.logErrorMessage("Upload error: " + jO.toJSONString());
        }
        return contractData;
    }

    public ContractData uploadImpl(String string, String string2) {
        byte[] byArray;
        TaggedDataAttachment taggedDataAttachment;
        if (string2 == null) {
            if (!this.contractSetup.isExist("packageName")) {
                throw new IllegalStateException("Contract package name not specified neither in the command nor in the contract manager config file");
            }
            string2 = this.contractSetup.getString("packageName");
        }
        String string3 = string2 + "." + string;
        String string4 = Nxt.getStringProperty(String.format(CONTRACT_MANAGER_PROPERTY_FORMAT, string, "filePath"));
        if (string4 == null && (string4 = this.contractSetup.getString("filePath")) == null) {
            string4 = string3.replace('.', '/') + ".class";
        }
        Logger.logInfoMessage("Loading resource from " + string4);
        byte[] byArray2 = ResourceLookup.getResourceBytes(string4);
        if (byArray2 == null) {
            throw new IllegalStateException("Cannot load " + string4);
        }
        String string5 = string4.substring(string4.lastIndexOf(47) + 1);
        String string6 = Search.detectMimeType(byArray2, string5);
        if (string6 == null) {
            throw new IllegalStateException("Cannot determine contract mime type i.e. class or jar file");
        }
        ContractData contractData = this.loadContract(string3, byArray2, string6, string4);
        Contract contract = contractData.getContract();
        Annotation[] annotationArray = contract.getClass().getAnnotations();
        Arrays.stream(annotationArray).forEach(annotation -> Logger.logInfoMessage(annotation.toString()));
        JO jO = new JO();
        ContractInfo contractInfo = contract.getClass().getDeclaredAnnotation(ContractInfo.class);
        Method[] methodArray = ContractInfo.class.getDeclaredMethods();
        Arrays.stream(methodArray).forEach(method -> {
            if (this.contractSetup.isExist(method.getName())) {
                jO.put(method.getName(), this.contractSetup.getString(method.getName()));
            } else if (Nxt.getStringProperty(String.format(CONTRACT_MANAGER_PROPERTY_FORMAT, string, method.getName())) != null) {
                jO.put(method.getName(), Nxt.getStringProperty(String.format(CONTRACT_MANAGER_PROPERTY_FORMAT, string, method.getName())));
            } else if (contractInfo != null) {
                String string2;
                try {
                    string2 = (String)method.invoke((Object)contractInfo, new Object[0]);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new IllegalStateException();
                }
                if (Convert.emptyToNull(string2) != null) {
                    jO.put(method.getName(), string2);
                }
            }
        });
        Logger.logInfoMessage("Contract Description %s", jO.toJSONString());
        try {
            taggedDataAttachment = new TaggedDataAttachment(string3, jO.toJSONString(), this.contractSetup.getString("tags", ""), contractData.getMimeType(), "contracts", false, string5, contractData.getBytes());
            byArray = taggedDataAttachment.getHash();
        }
        catch (NxtException.NotValidException notValidException) {
            throw new IllegalArgumentException(notValidException);
        }
        JO jO2 = LocalSigner.signAndBroadcast(this.childChain, 0L, taggedDataAttachment, this.secretPhrase, this.feeNQT, this.feeRateNQTPerFXT, this.minBundlerBalanceFXT, null, ContractManager.getUrl());
        if (jO2.isExist("fullHash")) {
            Logger.logInfoMessage("Contract class %s uploaded %s", taggedDataAttachment.getName(), jO2.getString("fullHash"));
        } else {
            Logger.logErrorMessage("Contract %s not uploaded, response %s", string, jO2.toJSONString());
        }
        return new ContractData(string, contractData.getFullName(), jO2, contractData.getBytes(), contractData.getMimeType(), contractData.getContract(), byArray);
    }

    private ContractData loadContract(String string, byte[] byArray, String string2, String string3) {
        Contract contract;
        switch (string2) {
            case "application/java-vm": {
                ContractLoader.CloudDataClassLoader cloudDataClassLoader = new ContractLoader.CloudDataClassLoader();
                contract = ContractLoader.loadContract(cloudDataClassLoader, string, byArray, null, null);
                if (contract == null) {
                    throw new IllegalStateException("Cannot load contract from file " + string);
                }
                Class<?>[] classArray = contract.getClass().getDeclaredClasses();
                if (classArray.length <= 0 || string3 == null) break;
                try {
                    Manifest manifest = new Manifest();
                    manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ReproducibleJarOutputStream reproducibleJarOutputStream = new ReproducibleJarOutputStream((OutputStream)byteArrayOutputStream, manifest, Constants.EPOCH_BEGINNING);
                    Path path = Paths.get(string3, new String[0]);
                    if (path.getNameCount() > 1) {
                        for (int i = 1; i < path.getNameCount(); ++i) {
                            String string4 = path.subpath(0, i).toString();
                            if (!(string4 = string4.replace("\\", "/")).endsWith("/")) {
                                string4 = string4 + "/";
                            }
                            JarEntry jarEntry = new JarEntry(string4);
                            ((JarOutputStream)reproducibleJarOutputStream).putNextEntry(jarEntry);
                            reproducibleJarOutputStream.closeEntry();
                        }
                    }
                    JarEntry jarEntry = new JarEntry(string3);
                    ((JarOutputStream)reproducibleJarOutputStream).putNextEntry(jarEntry);
                    reproducibleJarOutputStream.write(byArray);
                    Arrays.stream(classArray).forEach(clazz -> {
                        String string2 = clazz.getCanonicalName();
                        String[] stringArray = string3.split(".class");
                        String string3 = stringArray[0] + "$" + clazz.getSimpleName() + ".class";
                        Logger.logInfoMessage("Loading inner class %s resource from %s", string2, string3);
                        byte[] byArray = ResourceLookup.getResourceBytes(string3);
                        if (byArray == null) {
                            throw new IllegalStateException("Cannot load inner class from " + string3);
                        }
                        JarEntry jarEntry = new JarEntry(string3);
                        try {
                            reproducibleJarOutputStream.putNextEntry(jarEntry);
                            reproducibleJarOutputStream.write(byArray);
                            reproducibleJarOutputStream.closeEntry();
                        }
                        catch (IOException iOException) {
                            throw new IllegalStateException();
                        }
                    });
                    reproducibleJarOutputStream.close();
                    byArray = byteArrayOutputStream.toByteArray();
                    string2 = "application/java-archive";
                    cloudDataClassLoader = new ContractLoader.CloudDataClassLoader();
                    contract = ContractLoader.loadContractFromJar(cloudDataClassLoader, string, byArray, null, null);
                    if (contract == null) {
                        throw new IllegalStateException("Cannot load contract " + string + " from Jar file");
                    }
                    break;
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException);
                }
            }
            case "application/java-archive": {
                ContractLoader.CloudDataClassLoader cloudDataClassLoader = new ContractLoader.CloudDataClassLoader();
                contract = ContractLoader.loadContractFromJar(cloudDataClassLoader, string, byArray, null, null);
                if (contract != null) break;
                throw new IllegalStateException("Cannot load contract " + string + " from Jar file");
            }
            default: {
                throw new IllegalArgumentException(String.format("Resource mime type for %s does not represent a known executable contract format", string));
            }
        }
        return new ContractData(null, string, null, byArray, string2, contract, null);
    }

    public void reference(ContractData contractData, byte[] byArray) {
        JO jO = null;
        if (this.contractSetup != null && this.contractSetup.isExist("params")) {
            jO = this.contractSetup.getJo("params");
        }
        this.reference(contractData, byArray, jO);
    }

    public JO reference(ContractData contractData, byte[] byArray, JO jO) {
        ContractReferenceAttachment contractReferenceAttachment;
        JO jO2;
        AccessibleObject[] accessibleObjectArray;
        Class<?> clazz;
        JO jO3;
        String string = contractData.getContractName();
        Contract contract = contractData.getContract();
        if (contract == null) {
            jO3 = ((GetTaggedDataCall)GetTaggedDataCall.create(ChildChain.IGNIS.getId()).transactionFullHash(byArray).includeData(true).retrieve(true).remote(ContractManager.getUrl())).call();
            clazz = new TaggedDataResponseImpl(jO3);
            contract = this.loadContract(clazz.getName(), clazz.getData(), clazz.getType(), null).getContract();
        }
        jO3 = jO != null ? jO : new JO();
        clazz = ContractLoader.getParametersProvider(contract);
        if (clazz != null) {
            accessibleObjectArray = clazz.getDeclaredMethods();
            Arrays.stream(accessibleObjectArray).forEach(method -> {
                if (method.getDeclaredAnnotation(ContractSetupParameter.class) == null) {
                    return;
                }
                String string2 = method.getName();
                String string3 = Nxt.getStringProperty(String.format(CONTRACT_MANAGER_PROPERTY_PARAM_FORMAT, string, string2));
                if (string3 == null) {
                    return;
                }
                jO3.put(string2, string3);
            });
        }
        accessibleObjectArray = contract.getClass().getDeclaredFields();
        Arrays.stream(accessibleObjectArray).forEach(field -> {
            if (field.getDeclaredAnnotation(ContractSetupParameter.class) == null) {
                return;
            }
            String string2 = field.getName();
            String string3 = Nxt.getStringProperty(String.format(CONTRACT_MANAGER_PROPERTY_PARAM_FORMAT, string, string2));
            if (string3 == null) {
                return;
            }
            jO3.put(string2, string3);
        });
        String string2 = null;
        if (jO3.size() > 0) {
            string2 = jO3.toJSONString();
        }
        if (!(jO2 = LocalSigner.signAndBroadcast(ChildChain.IGNIS, 0L, contractReferenceAttachment = new ContractReferenceAttachment(string, string2, new ChainTransactionId(this.childChain.getId(), byArray)), this.secretPhrase, this.feeNQT, this.feeRateNQTPerFXT, this.minBundlerBalanceFXT, null, ContractManager.getUrl())).isExist("fullHash")) {
            Logger.logErrorMessage("Contract reference not registered %s response %s", string, jO2.toJSONString());
            return jO2;
        }
        Logger.logInfoMessage("Contract reference %s registered with params '%s' for contract %s", contractReferenceAttachment.getContractName(), contractReferenceAttachment.getContractParams(), contractReferenceAttachment.getContractId().toString());
        return jO2;
    }

    public void delete(String string) {
        String string2 = Convert.rsAccount(Account.getId(Crypto.getPublicKey(this.secretPhrase)));
        JO jO = this.listImpl(string2, string);
        List<JO> list = jO.getJoList("contractReferences");
        if (list.size() == 0) {
            Logger.logErrorMessage("Cannot find contract reference for account %s contract name %s", string2, string);
            return;
        }
        long l = list.get(0).getEntityId("id");
        ContractReferenceDeleteAttachment contractReferenceDeleteAttachment = new ContractReferenceDeleteAttachment(l);
        JO jO2 = LocalSigner.signAndBroadcast(ChildChain.IGNIS, 0L, contractReferenceDeleteAttachment, this.secretPhrase, this.feeNQT, this.feeRateNQTPerFXT, this.minBundlerBalanceFXT, null, ContractManager.getUrl());
        if (!jO2.isExist("fullHash")) {
            Logger.logErrorMessage("Contract reference delete for %s account %s failed with response %s", string, string2, jO2.toJSONString());
            return;
        }
        Logger.logInfoMessage("Contract reference %s deleted for account %s contract name %s", Long.toUnsignedString(contractReferenceDeleteAttachment.getContractReferenceId()), string2, string);
    }

    public boolean verify(String string, String string2) {
        byte[] byArray;
        String string3;
        JO jO = ((GetTaggedDataCall)GetTaggedDataCall.create(ChildChain.IGNIS.getId()).remote(ContractManager.getUrl())).transactionFullHash(string).includeData(true).retrieve(true).call();
        if (jO.toJSONObject().equals((Object)JSONResponses.PRUNED_TRANSACTION)) {
            Logger.logErrorMessage("Cannot load cloud data with hash %s transaction is pruned and cannot be retrieved by the current node", string);
            return false;
        }
        TaggedDataResponseImpl taggedDataResponseImpl = new TaggedDataResponseImpl(jO);
        if (taggedDataResponseImpl.getData() == null) {
            Logger.logErrorMessage("Cannot load cloud data with hash %s", string);
            return false;
        }
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        switch (string3 = taggedDataResponseImpl.getType()) {
            case "application/java-vm": {
                byArray = taggedDataResponseImpl.getData();
                hashMap.put(taggedDataResponseImpl.getName(), byArray);
                break;
            }
            case "application/java-archive": {
                ContractLoader.loadContractFromJar(new ContractLoader.CloudDataClassLoader(), taggedDataResponseImpl.getName(), taggedDataResponseImpl.getData(), null, null, hashMap);
                byArray = (byte[])hashMap.get(taggedDataResponseImpl.getName());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Resource mime type for transaction %s does not represent a known executable contract format", string));
            }
        }
        String string4 = JDKToolsWrapper.javap(byArray);
        if (string4 == null) {
            return false;
        }
        Logger.logInfoMessage("Use the following javac option: " + string4);
        String string5 = System.getProperty("java.io.tmpdir");
        Path path = Paths.get(string5, "src");
        Map<String, byte[]> map = JDKToolsWrapper.compile(string2, string4, path);
        if (map == null || map.size() == 0) {
            Logger.logErrorMessage("No class files were generated for %s", string2);
            return false;
        }
        for (String string6 : map.keySet()) {
            byte[] byArray2 = map.get(string6);
            if (byArray2 == null) {
                Logger.logErrorMessage("Cannot load class bytes for compiled class %s", new Object[]{map.keySet().stream().findFirst().orElse(null)});
                return false;
            }
            String string7 = string6.replace(path.toString(), "").replace(".class", "");
            String string8 = string7.substring(1).replace("\\", ".").replace("/", ".");
            if (!Arrays.equals(byArray2, (byte[])hashMap.get(string8))) {
                Logger.logErrorMessage("Verification failed - class files differ");
                Logger.logErrorMessage("Compiled class bytes length " + byArray2.length);
                Logger.logErrorMessage("Cloud data class bytes length " + byArray.length);
                Logger.logErrorMessage("Make sure the javac options used for verification are the same as the javac options used when compiling the blockchain contract");
                Logger.logErrorMessage("Make sure the Java version used for verification is the same as the Java version used when compiling the blockchain contract");
                return false;
            }
            Logger.logInfoMessage("Verification succeeded - class %s is identical", string6);
        }
        return true;
    }

    private static URL getUrl() {
        if (url != null) {
            return url;
        }
        String string = Convert.emptyToNull(Nxt.getStringProperty("contract.manager.serverAddress"));
        if (string == null) {
            return null;
        }
        String string2 = "http";
        boolean bl = Nxt.getBooleanProperty("contract.manager.useHttps");
        if (bl) {
            string2 = "https";
            HttpsURLConnection.setDefaultSSLSocketFactory(TrustAllSSLProvider.getSslSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(TrustAllSSLProvider.getHostNameVerifier());
        }
        int n = Constants.isTestnet ? API.TESTNET_API_PORT : Nxt.getIntProperty("nxt.apiServerPort");
        try {
            url = new URL(string2, string, n, "/nxt");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
        Logger.logInfoMessage("Connecting to URL " + url);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void waitForNextBlock() {
        JO jO2;
        String string;
        block4: {
            string = null;
            jO2 = ((EventRegisterCall)EventRegisterCall.create().event("Block.BLOCK_PUSHED").remote(ContractManager.getUrl())).call();
            Logger.logInfoMessage("Waiting for new block %s", jO2.toJSONString());
            if (jO2.isExist("token")) break block4;
            Logger.logInfoMessage("Something went wrong %s", jO2.toJSONString());
            if (string == null) return;
            JO jO3 = ((EventRegisterCall)EventRegisterCall.create().token(string).remove(true).remote(ContractManager.getUrl())).call();
            Logger.logInfoMessage("EventRegisterCall remove %s", jO3.toJSONString());
            return;
        }
        try {
            JA jA;
            string = jO2.getString("token");
            while ((jA = (jO2 = ((EventWaitCall)EventWaitCall.create().timeout(1L).token(string).remote(ContractManager.getUrl())).call()).getArray("events")).size() <= 0) {
                System.out.print(".");
            }
            System.out.println();
            jA.objects().forEach(jO -> Logger.logInfoMessage("" + jO));
            if (string == null) return;
        }
        catch (Throwable throwable) {
            if (string == null) throw throwable;
            JO jO4 = ((EventRegisterCall)EventRegisterCall.create().token(string).remove(true).remote(ContractManager.getUrl())).call();
            Logger.logInfoMessage("EventRegisterCall remove %s", jO4.toJSONString());
            throw throwable;
        }
        jO2 = ((EventRegisterCall)EventRegisterCall.create().token(string).remove(true).remote(ContractManager.getUrl())).call();
        Logger.logInfoMessage("EventRegisterCall remove %s", jO2.toJSONString());
    }

    public static class ContractData {
        private final String contractName;
        private final String fullName;
        private final JO response;
        private final byte[] bytes;
        private final String mimeType;
        private final Contract contract;
        private final byte[] taggedDataHash;

        public ContractData(String string) {
            this.contractName = string;
            this.fullName = null;
            this.response = null;
            this.bytes = null;
            this.mimeType = null;
            this.contract = null;
            this.taggedDataHash = null;
        }

        public ContractData(String string, String string2, JO jO, byte[] byArray, String string3, Contract contract, byte[] byArray2) {
            this.contractName = string;
            this.fullName = string2;
            this.response = jO;
            this.bytes = byArray;
            this.mimeType = string3;
            this.contract = contract;
            this.taggedDataHash = byArray2;
        }

        public String getContractName() {
            return this.contractName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public JO getResponse() {
            return this.response;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Contract getContract() {
            return this.contract;
        }

        public byte[] getTaggedDataHash() {
            return this.taggedDataHash;
        }
    }

    public static enum OPTION {
        NAME('n', "name", true, "contract name", false, new OPTION[]{null}),
        PACKAGE('p', "package", true, "package name", false, new OPTION[]{null}),
        HASH('h', "hash", true, "contract full hash", false, new OPTION[]{null}),
        ACCOUNT('a', "account", true, "account id", false, new OPTION[]{null}),
        SOURCE('s', "source", true, "path to source code file to verify", false, new OPTION[]{null}),
        UPLOAD('u', "upload", false, "upload new contract", true, NAME, PACKAGE),
        REFERENCE('r', "reference", false, "reference existing contract", true, HASH, NAME),
        DELETE('d', "delete", false, "delete reference", true, NAME),
        LIST('l', "list", false, "list contract references for account", true, ACCOUNT),
        VERIFY('v', "verify", false, "Verify that the source code provided represents the deployed contract", true, HASH, SOURCE);

        private final char opt;
        private final String longOpt;
        private boolean hasArgs;
        private String description;
        private boolean isAction;
        private OPTION[] dependencies;

        private OPTION(char c, String string2, boolean bl, String string3, boolean bl2, OPTION ... oPTIONArray) {
            this.opt = c;
            this.longOpt = string2;
            this.hasArgs = bl;
            this.description = string3;
            this.isAction = bl2;
            this.dependencies = oPTIONArray;
        }

        public String getOpt() {
            return Character.toString(this.opt);
        }

        public String getLongOpt() {
            return this.longOpt;
        }

        public boolean hasArgs() {
            return this.hasArgs;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isAction() {
            return this.isAction;
        }

        public OPTION[] getDependencies() {
            return this.dependencies;
        }
    }
}

